<?php

error_reporting(0);

header('Access-Control-Allow-Origin: *');
header("Content-Type: application/xml");
	
include_once 'config.php';
if (!empty($_GET)) {
    $in = $_GET;
} else if (!empty($HTTP_GET_VARS)) {
    $in = $HTTP_GET_VARS;
}

if (!empty($_POST)) {
    $in = $_POST;
} else if (!empty($HTTP_POST_VARS)) {
    $in = $HTTP_POST_VARS;
}

if (empty($in)) {
    $in = array();
}

### gpx export####
   

    header('Content-Disposition: attachment; filename="' . $in['name'] . '.gpx"');
    
    $out= "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>
<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" version=\"1.1\" creator=\"RouteGadget GPS Tracking\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:tp1=\"http://www.garmin.com/xmlschemas/TrackPointExtension/v1\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd http://www.garmin.com/xmlschemas/TrackPointExtension/v1 http://www.garmin.com/xmlschemas/TrackPointExtensionv1.xsd\">
<trk>
<trkseg>";
    
    $events  = file($path . '/events.txt');
    $pretime = -1;
    for ($c = 0; $c < count($events); $c++) {
        list($id, $date, $image, $name, $details) = explode('|', $events[$c], 5);
        
        $id = 1 * $id;
        
        if ($id == $in['id']) {
            
            $zip = new ZipArchive;
            if ($zip->open($path . '/archive' . (1 * $id) . '.zip') === TRUE) {
                $dat = $zip->getFromName('gps.txt');
                $zip->close();
            }
            
            $d = json_decode('[' . $dat . '{}]');
            
            $format = "Y-m-d\TH:i:s\Z";
            
            for ($i = 0; $i < count($d); $i++) {
                
                if ($d[$i]->id == $in['aid'] && $pretime < $d[$i]->sec) {
                    $pretime = $d[$i]->sec;
                    $rname   = $d[$i]->name;
                    
                    $out.= "<trkpt lat=\"" . ($d[$i]->lat) . "\" lon=\"" . ($d[$i]->lon) . "\">
<time>" . gmdate($format, ($d[$i]->sec)) . "</time>
</trkpt>\n";
                    
                }
            }
        }
    }


    $out.="</trkseg>
<name>$rname</name>
</trk>
</gpx>";#<name>$rname</name>

print remove_utf8_bom($out);

function remove_utf8_bom($text)
{
    $bom = pack('H*','EFBBBF');
    $text = preg_replace("/^$bom/", '', $text);
    return $text;
}

