/*
 * Decompiled with CFR 0.152.
 */
public class Time {
    private int secondsFromMidnight = 0;
    private boolean validTime = true;
    public static final Time ZEROTIME = new Time(0, true);
    public static final Time MAXTIME = new Time(Integer.MAX_VALUE, true);
    public static final Time INVALIDTIME = new Time(Integer.MAX_VALUE, false);
    public static final Time NULLTIME = new Time(0, false);

    public Time() {
    }

    public Time(int minutes, int seconds) {
        this.secondsFromMidnight = minutes * 60 + seconds;
        this.validTime = true;
    }

    public Time(int seconds, boolean valid) {
        this.secondsFromMidnight = seconds;
        this.validTime = valid;
    }

    public Time(Time time) {
        this.secondsFromMidnight = time.secondsFromMidnight;
        this.validTime = time.validTime;
    }

    public Time(String timeStr) throws Exception {
        if (timeStr.indexOf(":") == -1) {
            this.secondsFromMidnight = timeStr.equals("0.00") ? 0 : Integer.MAX_VALUE;
            this.validTime = false;
        } else {
            try {
                int firstSep = timeStr.indexOf(":");
                int lastSep = timeStr.lastIndexOf(":");
                if (firstSep == lastSep) {
                    String minString = timeStr.substring(0, firstSep);
                    String secString = timeStr.substring(firstSep + 1);
                    this.secondsFromMidnight = Integer.parseInt(minString) * 60 + Integer.parseInt(secString);
                    this.validTime = true;
                } else {
                    String hourString = firstSep == 0 ? "1" : timeStr.substring(0, firstSep);
                    String minString = timeStr.substring(firstSep + 1, lastSep);
                    String secString = timeStr.substring(lastSep + 1);
                    this.secondsFromMidnight = (Integer.parseInt(hourString) * 60 + Integer.parseInt(minString)) * 60 + Integer.parseInt(secString);
                    this.validTime = true;
                }
            }
            catch (NumberFormatException e) {
                throw new Exception(Message.get("Time.BadSplit").concat(timeStr));
            }
        }
    }

    public Time(int newSecondsFromMidnight) {
        this.secondsFromMidnight = newSecondsFromMidnight;
        this.validTime = true;
    }

    public int asSeconds() {
        return this.secondsFromMidnight;
    }

    public void setSeconds(int newSeconds) {
        this.secondsFromMidnight = newSeconds;
    }

    public boolean isValid() {
        return this.validTime;
    }

    public boolean isFailedSIBox() {
        return !this.validTime && this.secondsFromMidnight == 0;
    }

    public void setValid(boolean newValid) {
        this.validTime = newValid;
    }

    public String toString() {
        if (this.validTime) {
            if (this.secondsFromMidnight < 0) {
                return "-" + this.pad(this.getMins()) + ':' + this.pad(this.getSecs());
            }
            if (this.secondsFromMidnight > 32400) {
                return String.valueOf(this.pad(this.getHour())) + ":" + this.pad(this.getMinsPerHour()) + ':' + this.pad(this.getSecs());
            }
            return String.valueOf(this.pad(this.getMins())) + ':' + this.pad(this.getSecs());
        }
        if (this.secondsFromMidnight == 0) {
            return "0.00 ";
        }
        return "-----";
    }

    private int getSecs() {
        return Math.abs(this.secondsFromMidnight - this.getMins() * 60);
    }

    private int getMins() {
        return this.secondsFromMidnight / 60;
    }

    private int getMinsPerHour() {
        return this.secondsFromMidnight / 60 % 60;
    }

    private int getHour() {
        return this.secondsFromMidnight / 3600;
    }

    private String pad(int value) {
        if (value < 10) {
            return "0" + new Integer(Math.abs(value)).toString();
        }
        return new Integer(Math.abs(value)).toString();
    }

    public Time subtract(Time time2) {
        if (this.validTime && time2.isValid()) {
            return new Time(this.secondsFromMidnight - time2.asSeconds());
        }
        if (this.secondsFromMidnight == Integer.MAX_VALUE || time2.asSeconds() == Integer.MAX_VALUE) {
            return INVALIDTIME;
        }
        return new Time(this.secondsFromMidnight - time2.asSeconds(), false);
    }

    public Time add(Time time2) {
        if (this.validTime && time2.isValid()) {
            return new Time(this.secondsFromMidnight + time2.asSeconds());
        }
        if (this.secondsFromMidnight == Integer.MAX_VALUE || time2.asSeconds() == Integer.MAX_VALUE) {
            return INVALIDTIME;
        }
        return new Time(this.secondsFromMidnight + time2.asSeconds(), false);
    }

    public boolean lessThan(Time time2) {
        if (!this.validTime || !time2.isValid()) {
            return false;
        }
        return this.secondsFromMidnight < time2.asSeconds();
    }
}

