/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.TextArea;

public class SplitsTable
extends TextArea {
    BorderLayout borderLayout1 = new BorderLayout();
    private Course course;
    private AgeClass ageClass;
    private boolean ageClassInvalid = true;
    private boolean showTotalTime = true;
    private boolean showTotalPos = false;
    private boolean showSplits = true;
    private boolean showSplitPos = false;
    private boolean showTimeBehind = false;
    protected int CONTROL_REQ = 5;
    protected String CONTROL_GAP = "  ";
    protected int CONTROL_COLS = this.CONTROL_REQ + this.CONTROL_GAP.length();
    protected String NAME_PADDING = "                   ";
    protected String POS_PADDING = "     ";
    protected String TITLE_PADDING = String.valueOf(this.POS_PADDING) + this.NAME_PADDING + "        ";
    protected int TITLE_COLS = this.TITLE_PADDING.length();
    private static int FIELD_WIDTH = 7;
    private static int NAME_WIDTH = 20;

    public SplitsTable() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(403, 291));
        this.setFont(new Font("Courier", 0, 11));
        this.setBackground(Color.white);
        this.setEditable(false);
    }

    public void setShowTotalTime(boolean newShowTotalTime) {
        this.showTotalTime = newShowTotalTime;
        this.ageClassInvalid = true;
        this.repaint();
    }

    public boolean getShowTotalTime() {
        return this.showTotalTime;
    }

    public void setShowTotalPos(boolean newShowTotalPos) {
        this.showTotalPos = newShowTotalPos;
        this.ageClassInvalid = true;
        this.repaint();
    }

    public boolean getShowTotalPos() {
        return this.showTotalPos;
    }

    public void setShowSplits(boolean newShowSplits) {
        this.showSplits = newShowSplits;
        this.ageClassInvalid = true;
        this.repaint();
    }

    public boolean getShowSplits() {
        return this.showSplits;
    }

    public void setShowSplitPos(boolean newShowSplitPos) {
        this.showSplitPos = newShowSplitPos;
        this.ageClassInvalid = true;
        this.repaint();
    }

    public boolean getShowSplitPos() {
        return this.showSplitPos;
    }

    public void setShowTimeBehind(boolean newShowTimeBehind) {
        this.showTimeBehind = newShowTimeBehind;
        this.ageClassInvalid = true;
        this.repaint();
    }

    public boolean getShowTimeBehind() {
        return this.showTimeBehind;
    }

    public void setAgeClass(Course newCourse, AgeClass newAgeClass) {
        if (newCourse == null || newAgeClass == null) {
            System.out.println("[setAgeClass] null");
            this.setText(Message.get("Table.SelectOneClass"));
        }
        this.course = newCourse;
        this.ageClass = newAgeClass;
        this.ageClassInvalid = true;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.ageClassInvalid) {
            if (this.ageClass != null) {
                this.setCols();
                this.setRows();
                this.setAgeClassText();
            }
            this.ageClassInvalid = false;
        }
    }

    protected void setCols() {
        int numCols = this.course.getNumControls() * this.CONTROL_COLS + this.TITLE_COLS;
        this.setColumns(numCols);
    }

    protected int rowsPerResult() {
        int rowsPerResult = 2;
        if (this.showSplits) {
            ++rowsPerResult;
        }
        return rowsPerResult;
    }

    private void setRows() {
        int rows = this.ageClass.getNumResults() * this.rowsPerResult();
        this.setRows(rows);
    }

    private String leftPad(String value, int len) {
        String s = value;
        while (len > s.length()) {
            s = " " + s;
        }
        return s;
    }

    private String rightPad(String value, int len) {
        String s = value;
        while (s.length() < len) {
            s = String.valueOf(s) + " ";
        }
        return s;
    }

    protected void setAgeClassText() {
        boolean showPos = this.showSplitPos | this.showTotalPos;
        int pW = 3;
        int nR = this.ageClass.getNumResults();
        if (nR >= 10) {
            ++pW;
        }
        if (nR > 100) {
            ++pW;
        }
        if (!showPos) {
            pW = 0;
        }
        StringBuffer s = new StringBuffer(this.getColumns() * this.getRows());
        s.append("  " + this.ageClass.getName() + "  " + this.course.getDistance() + " " + this.course.getClimb() + "m " + this.course.getNumControls() + "\n");
        String z1 = "          ";
        String z2 = "          ";
        int iSplit = 0;
        while (iSplit < this.course.getNumControls()) {
            if (this.course.isValidControl(iSplit)) {
                z1 = String.valueOf(z1) + this.leftPad(Integer.toString(iSplit + 1), FIELD_WIDTH + pW);
                if (this.course.getControlCode(iSplit) != "") {
                    z2 = String.valueOf(z2) + this.leftPad("(" + this.course.getControlCode(iSplit) + ")", FIELD_WIDTH + pW);
                }
            }
            ++iSplit;
        }
        s.append(String.valueOf(this.rightPad("", 30 - pW)) + z1 + " " + this.leftPad(Message.get("Graph.Finish"), FIELD_WIDTH + pW) + "\n");
        if (!z2.equals("")) {
            s.append(String.valueOf(this.rightPad("", 32 - pW)) + z2 + "\n");
        }
        s.append("\n");
        Time lastFinishTime = Time.ZEROTIME;
        int res = 0;
        while (res < this.ageClass.getNumResults()) {
            String str;
            Result result = this.ageClass.getResult(res);
            String name = result.getName(NAME_WIDTH);
            String pos = this.leftPad(Integer.toString(res + 1), 3);
            if (!result.isValid() || result.getFinishTime().asSeconds() == lastFinishTime.asSeconds()) {
                pos = "   ";
            }
            s.append(String.valueOf(pos) + "  " + name);
            lastFinishTime = result.getFinishTime();
            if (result.getStartTime().isValid()) {
                s.append(this.leftPad("[" + result.getStartTime().toString() + "]", 10));
            } else {
                s.append("  [------]");
            }
            s.append(this.leftPad(result.getFinishTime().toString(), 7));
            boolean invalidTimeFnd = false;
            int iSplit2 = 0;
            while (iSplit2 <= this.course.getNumControls()) {
                if (this.course.isValidControl(iSplit2)) {
                    invalidTimeFnd = invalidTimeFnd || !result.getTime(iSplit2).isValid() && !result.isValid();
                    s.append(this.leftPad(result.getTime(iSplit2).toString(), FIELD_WIDTH));
                    str = "";
                    if (showPos && result.getTime(iSplit2).isValid() && !invalidTimeFnd) {
                        str = result.getTotalPos(iSplit2) > 0 ? "(" + Integer.toString(result.getTotalPos(iSplit2)) + ")" : "(-)";
                    }
                    s.append(this.rightPad(str, pW));
                }
                ++iSplit2;
            }
            s.append("\n");
            if (this.showSplits) {
                s.append("     " + this.rightPad(result.getClub(), NAME_WIDTH + 6) + "           ");
                iSplit2 = 0;
                while (iSplit2 <= this.course.getNumControls()) {
                    if (this.course.isValidControl(iSplit2)) {
                        s.append(this.leftPad(result.getSplitTime(iSplit2).toString(), FIELD_WIDTH));
                        str = "";
                        if (showPos && result.getSplitTime(iSplit2).isValid()) {
                            str = result.getSplitPos(iSplit2) > 0 ? "(" + Integer.toString(result.getSplitPos(iSplit2)) + ")" : "(-)";
                        }
                        s.append(this.rightPad(str, pW));
                    }
                    ++iSplit2;
                }
                s.append("\n");
            }
            s.append("\n");
            ++res;
        }
        this.setText(s.toString());
    }
}

