/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class SplitsGraph
extends Panel {
    public static final int GRAPH_TYPE_COMPARISON = 0;
    public static final int GRAPH_TYPE_ABSOLUTE = 1;
    public static final int GRAPH_TYPE_PERCENTBEHIND = 2;
    public static final int GRAPH_TYPE_POS = 3;
    public static final int GRAPH_TYPE_SPLITPOS = 4;
    private static final int GRAPH_TYPE_MAX = 5;
    private Image offscreenBuffer;
    private Color color1 = new Color(216, 220, 255);
    private Color color2 = new Color(224, 232, 240);
    private Color gridColor = Color.white;
    private Course course = null;
    private static Vector displayedResults = new Vector();
    private static Vector displayColors = new Vector();
    private Result reference;
    private Axis xAxis = new Axis(false);
    private Axis yAxis = new Axis(false);
    private boolean computeDimensions = true;
    private int[] xPos = null;
    private int graphType = 0;
    private final int LEFT_MARGIN = 20;
    private final int RIGHT_MARGIN = 10;
    private final int TOP_MARGIN = 25;
    private final int BOTTOM_MARGIN = 30;
    private int LEFT_AXIS = 0;
    private int RIGHT_AXIS = 1;
    private boolean thickLine = true;
    private int selectedSplit = -2;
    private boolean showTotalTime = true;
    private boolean showTotalPos = false;
    private boolean showSplits = true;
    private boolean showSplitPos = false;
    private boolean showTimeBehind = false;
    private ControlCollection cc;
    private Dimension dim;
    private int legendSlotHeight;
    private SelectedResults selectedResults;
    private String eventName;
    private boolean showInfoComparison = true;
    private boolean showInfoAbsolute = true;
    private LessThanResult lt = new LessThanResult();
    private Time[] timesAtControl = null;
    private String[] controlVisitors = null;
    private int cvX;
    private int cvY;

    public SplitsGraph() {
        this.setFont(new Font("SansSerif", 0, 10));
        this.enableEvents(32L);
        MyListener myListener = new MyListener();
        this.addMouseListener(myListener);
        this.addMouseMotionListener(myListener);
        this.dim = this.getSize();
    }

    public void setColor1(Color newColor1) {
        if (this.color1 != newColor1) {
            this.color1 = newColor1;
            this.repaint();
        }
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor2(Color newColor2) {
        if (this.color2 != newColor2) {
            this.color2 = newColor2;
            this.repaint();
        }
    }

    public Color getColor2() {
        return this.color2;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color newColor) {
        this.gridColor = newColor;
        this.repaint();
    }

    public void setThickLine(boolean newThickLine) {
        this.thickLine = newThickLine;
        this.repaint();
    }

    public void setCourse(Course newCourse) {
        this.course = newCourse;
        displayedResults.removeAllElements();
        displayColors.removeAllElements();
        this.reference = this.selectedResults.getReferenceResult();
        if (newCourse != null) {
            this.xPos = new int[this.course.getNumControls() + 3];
        }
    }

    public void invalidateDimensions() {
        this.computeDimensions = true;
        this.repaint();
    }

    public void setShowTotalTime(boolean newShowTotalTime) {
        this.showTotalTime = newShowTotalTime;
        this.invalidateDimensions();
    }

    public boolean getShowTotalTime() {
        return this.showTotalTime;
    }

    public void setShowTotalPos(boolean newShowTotalPos) {
        this.showTotalPos = newShowTotalPos;
        this.invalidateDimensions();
    }

    public boolean getShowTotalPos() {
        return this.showTotalPos;
    }

    public void setShowSplits(boolean newShowSplits) {
        this.showSplits = newShowSplits;
        this.invalidateDimensions();
    }

    public boolean getShowSplits() {
        return this.showSplits;
    }

    public void setShowSplitPos(boolean newShowSplitPos) {
        this.showSplitPos = newShowSplitPos;
        this.invalidateDimensions();
    }

    public boolean getShowSplitPos() {
        return this.showSplitPos;
    }

    public void setShowTimeBehind(boolean newShowTimeBehind) {
        this.showTimeBehind = newShowTimeBehind;
        this.invalidateDimensions();
    }

    public boolean getShowTimeBehind() {
        return this.showTimeBehind;
    }

    public void setControlCollection(ControlCollection newCC) {
        this.cc = newCC;
    }

    public void setSelectedResults(SelectedResults newSelectedResults) {
        this.selectedResults = newSelectedResults;
    }

    public void displayResult(int newResult) {
        Color[] colors = new Color[]{Color.red, Color.blue, Color.green, Color.black, new Color(0xCC0066), new Color(153), new Color(0xFFCC00), new Color(0x996600), new Color(0x9900FF), new Color(0xCCCC00), new Color(0xFFFF66), new Color(0xCC6699), new Color(0x99FF33), new Color(0x3399FF), new Color(0xCC33CC), new Color(0x33FFFF), new Color(0xFF00FF)};
        displayedResults.addElement(new Integer(newResult));
        displayColors.addElement(new Color(colors[newResult % colors.length].getRGB()));
        this.controlVisitors = null;
        this.invalidateDimensions();
    }

    public void removeAllResults() {
        displayedResults.removeAllElements();
        displayColors.removeAllElements();
        this.controlVisitors = null;
        this.invalidateDimensions();
    }

    public void removeResult(int iResult) {
        int index = displayedResults.indexOf(new Integer(iResult));
        if (index != -1) {
            displayedResults.removeElementAt(index);
            displayColors.removeElementAt(index);
            this.controlVisitors = null;
            this.invalidateDimensions();
        }
    }

    public void setGraphType(int newGraphType) throws Exception {
        if (newGraphType >= 5) {
            throw new Exception("[SplitsGraph.setGraphType] Invalid graph type. Consult programmer.");
        }
        if (this.graphType != newGraphType) {
            this.graphType = newGraphType;
            this.invalidateDimensions();
        }
        if (this.graphType == 0 && this.showInfoComparison) {
            this.controlVisitors = new String[5];
            this.controlVisitors[0] = Message.get("Graph.TimeDiffInfo1");
            this.controlVisitors[1] = Message.get("Graph.TimeDiffInfo2");
            this.controlVisitors[2] = Message.get("Graph.TimeDiffInfo3");
            this.controlVisitors[3] = Message.get("Graph.TimeDiffInfo4");
            this.controlVisitors[4] = Message.get("Graph.TimeDiffInfo5");
            this.showInfoComparison = false;
            this.cvX = 100;
            this.cvY = 100;
        }
        if (this.graphType == 1 && this.showInfoAbsolute) {
            this.controlVisitors = new String[6];
            this.controlVisitors[0] = Message.get("Graph.AbsoluteInfo1");
            this.controlVisitors[1] = Message.get("Graph.AbsoluteInfo2");
            this.controlVisitors[2] = Message.get("Graph.AbsoluteInfo3");
            this.controlVisitors[3] = Message.get("Graph.AbsoluteInfo4");
            this.controlVisitors[4] = Message.get("Graph.AbsoluteInfo5");
            this.controlVisitors[5] = Message.get("Graph.AbsoluteInfo6");
            this.showInfoAbsolute = false;
            this.cvX = 100;
            this.cvY = 100;
        }
    }

    public void setEventName(String newEventName) {
        this.eventName = newEventName;
    }

    public void showInfoText() {
        this.showInfoComparison = true;
        this.showInfoAbsolute = true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension newSize = this.getSize();
        this.reference = this.selectedResults.getReferenceResult();
        if (this.course == null) {
            g.setColor(this.getParent().getBackground());
            g.fillRect(0, 0, this.dim.width, this.dim.height);
            return;
        }
        if (this.computeDimensions || this.dim.width != newSize.width || this.dim.height != newSize.height) {
            this.computeGraphDimensions(g);
            this.computeXPositions();
        }
        this.drawOffscreenImage();
        g.drawImage(this.offscreenBuffer, 0, 0, this);
    }

    private Result getDisplayedResult(int i) {
        int resultNo = (Integer)displayedResults.elementAt(i);
        return this.selectedResults.getResult(resultNo);
    }

    private void drawOffscreenImage() {
        Dimension dim = this.getSize();
        this.offscreenBuffer = this.createImage(dim.width, dim.height);
        Graphics g = this.offscreenBuffer.getGraphics();
        FontMetrics fontMetrics = g.getFontMetrics(g.getFont());
        int fontHeight = fontMetrics.getHeight();
        this.legendSlotHeight = fontHeight - 4;
        int halfFontHeight = fontHeight / 2;
        int textGap = 2;
        this.paintBackground(g);
        this.reference = this.selectedResults.getReferenceResult();
        boolean yrunner0 = false;
        Object[] sortedByFinishTime = new Integer[displayedResults.size()];
        int[] legend = new int[displayedResults.size()];
        int nToSort = 0;
        int i = 0;
        while (i < displayedResults.size()) {
            int y;
            g.setColor((Color)displayColors.elementAt(i));
            Result result = this.getDisplayedResult(i);
            Time tOld = this.getYFirst(result);
            int yOld = this.yAxis.toPixel(tOld.asSeconds());
            int xOld = this.xPos[0];
            int splitCount = 0;
            while (splitCount < result.getNumControls() + 1) {
                if (this.course.isValidControl(splitCount)) {
                    Time t = this.getYTime(result, splitCount);
                    y = this.yAxis.toPixel(t.asSeconds());
                    if (t.isValid() && tOld.isValid()) {
                        g.drawLine(xOld, yOld, this.xPos[splitCount + 1], y);
                        if (this.thickLine) {
                            g.drawLine(xOld, yOld + 1, this.xPos[splitCount + 1], y + 1);
                            g.drawLine(xOld + 1, yOld, this.xPos[splitCount + 1] + 1, y);
                        }
                    }
                    yOld = y;
                    xOld = this.xPos[splitCount + 1];
                    tOld = t;
                }
                ++splitCount;
            }
            Time yTime = this.getYTime(result, this.course.getNumControls());
            if (!yTime.isValid()) {
                yTime = Time.INVALIDTIME;
            }
            result.setSortTime(yTime);
            sortedByFinishTime[nToSort++] = new Integer(i + 1);
            if (this.graphType == 1) {
                if (this.getYFirst(result).isValid()) {
                    y = this.yAxis.toPixel(this.getYFirst(result).asSeconds());
                    g.setColor(this.getForeground());
                } else {
                    y = this.yAxis.getMaxPixel() - fontHeight;
                    g.setColor(Color.red);
                }
                g.drawString(this.getLeftText(result), 20, y);
            }
            ++i;
        }
        Sorter.Sort(sortedByFinishTime, 0, nToSort - 1, this.lt);
        int maxYLegend = this.yAxis.getMaxPixel() + this.legendSlotHeight;
        int maxShownRunners = (maxYLegend - this.yAxis.getMinPixel()) / this.legendSlotHeight - 1;
        if (nToSort > maxShownRunners) {
            nToSort = maxShownRunners;
        }
        int oldY = 0;
        int i2 = 0;
        while (i2 < nToSort) {
            int y = this.yAxis.toPixel(this.getDisplayedResult((Integer)sortedByFinishTime[i2] - 1).getSortTime().asSeconds());
            if (y != Time.INVALIDTIME.asSeconds()) {
                y += halfFontHeight;
            }
            if (y - oldY < this.legendSlotHeight) {
                y = oldY + this.legendSlotHeight;
            }
            legend[i2] = y;
            if (y > maxYLegend) {
                int moveDist = y - maxYLegend;
                int i1 = i2;
                while (i1 >= 0 && moveDist >= 0) {
                    int n = i1;
                    legend[n] = legend[n] - moveDist;
                    if (i1 > 0) {
                        moveDist = this.legendSlotHeight - (legend[i1] - legend[i1 - 1]);
                    }
                    --i1;
                }
            }
            oldY = legend[i2];
            ++i2;
        }
        int xright = this.xAxis.getMaxPixel();
        int posL = 0;
        while (posL < nToSort) {
            if (legend[posL] != 0) {
                int y = legend[posL];
                g.setColor((Color)displayColors.elementAt((Integer)sortedByFinishTime[posL] - 1));
                g.drawLine(xright + 4, y - halfFontHeight, xright + 16, y - halfFontHeight);
                g.drawLine(xright + 4, y - halfFontHeight + 1, xright + 16, y - halfFontHeight + 1);
                g.setColor(Color.black);
                g.drawString(this.getRightText(this.getDisplayedResult((Integer)sortedByFinishTime[posL] - 1), this.selectedSplit), xright + 20, y);
            }
            ++posL;
        }
        if (this.controlVisitors != null) {
            this.showControlVisitors(g);
        }
        if (this.timesAtControl != null && this.timesAtControl.length > 0) {
            this.showTimesAtControl(g);
        }
    }

    protected void paintBackground(Graphics g) {
        Dimension dim = this.getSize();
        g.setColor(this.getBackground());
        g.draw3DRect(1, 1, dim.width - 2, dim.height - 2, false);
        FontMetrics fontMetrics = g.getFontMetrics(g.getFont());
        int fontHeight = fontMetrics.getHeight();
        int halfFontHeight = fontHeight / 2;
        int fontAscent = fontMetrics.getAscent();
        boolean useColor1 = true;
        int lastPos = this.xPos[0];
        int i = 1;
        while (i <= this.course.getNumControls() + 1) {
            if (this.course.isValidControl(i - 1)) {
                if (useColor1) {
                    g.setColor(this.color1);
                } else {
                    g.setColor(this.color2);
                }
                g.fillRect(lastPos, this.yAxis.getMinPixel(), this.xPos[i] - lastPos, this.yAxis.getMaxPixel() - this.yAxis.getMinPixel());
                lastPos = this.xPos[i];
                useColor1 = !useColor1;
            }
            ++i;
        }
        g.setColor(this.gridColor);
        int x0 = this.xAxis.getMinPixel();
        int x1 = this.xAxis.getMaxPixel();
        i = 0;
        while (i < this.yAxis.getNumLabels()) {
            g.drawLine(x0, this.yAxis.getLabelPixel(i), x1, this.yAxis.getLabelPixel(i));
            ++i;
        }
        g.setColor(this.gridColor);
        g.draw3DRect(this.xAxis.getMinPixel() - 1, this.yAxis.getMinPixel(), this.xAxis.getMaxPixel() - this.xAxis.getMinPixel() + 1, this.yAxis.getMaxPixel() - this.yAxis.getMinPixel(), false);
        int y = this.yAxis.getMinPixel() - 5;
        i = 0;
        while (i < this.course.getNumControls()) {
            String label = new Integer(i + 1).toString();
            if (this.course.isValidControl(i)) {
                g.setColor(this.getForeground());
            } else {
                g.setColor(Color.red);
                g.drawLine(this.xPos[i + 1] - fontMetrics.stringWidth(label) / 2 - 4, y + 2, this.xPos[i + 1] + fontMetrics.stringWidth(label) / 2 + 4, y - fontAscent);
                g.drawLine(this.xPos[i + 1] - fontMetrics.stringWidth(label) / 2 - 3, y + 2, this.xPos[i + 1] + fontMetrics.stringWidth(label) / 2 + 5, y - fontAscent);
                g.drawLine(this.xPos[i + 1] - fontMetrics.stringWidth(label) / 2 - 4, y - fontAscent, this.xPos[i + 1] + fontMetrics.stringWidth(label) / 2 + 4, y + 2);
                g.drawLine(this.xPos[i + 1] - fontMetrics.stringWidth(label) / 2 - 3, y - fontAscent, this.xPos[i + 1] + fontMetrics.stringWidth(label) / 2 + 5, y + 2);
            }
            g.drawString(label, this.xPos[i + 1] - fontMetrics.stringWidth(label) / 2, y);
            ++i;
        }
        g.setColor(this.getForeground());
        int nC = this.course.getNumControls();
        int posFinish = this.xPos[nC] + fontMetrics.stringWidth(new Integer(nC).toString()) / 2 + 4;
        String s = Message.get("Graph.Finish");
        if (this.xPos[nC + 1] - fontMetrics.stringWidth(s) / 2 > posFinish) {
            posFinish = this.xPos[nC + 1] - fontMetrics.stringWidth(s) / 2;
        }
        g.drawString(s, posFinish, y);
        String start = Message.get("Graph.Start");
        g.drawString(start, this.xPos[0] - fontMetrics.stringWidth(start) / 2, y);
        y = this.yAxis.getMaxPixel() + fontMetrics.getHeight();
        i = 0;
        while (i < this.xAxis.getNumLabels()) {
            g.drawString(this.xAxis.getLabelString(i), this.xAxis.getLabelPixel(i), y);
            ++i;
        }
        i = this.xAxis.getNumLabels() - 1;
        g.drawString(Message.get("Graph.Time"), this.xAxis.getLabelPixel(i) - fontMetrics.stringWidth(Message.get("Graph.Time")) / 2, y + fontHeight);
        g.drawString(this.eventName, this.xAxis.getLabelPixel(0), y + fontHeight);
        String labelSuffix = "";
        if (this.graphType == 2) {
            labelSuffix = " %";
        }
        i = 0;
        while (i < this.yAxis.getNumLabels()) {
            s = String.valueOf(this.yAxis.getLabelString(i)) + labelSuffix;
            int x = this.xAxis.getMinPixel() - fontMetrics.stringWidth(s);
            g.drawString(s, x, this.yAxis.getLabelPixel(i) + halfFontHeight);
            ++i;
        }
        if (this.selectedSplit >= -1 && (this.showSplits || this.showTimeBehind)) {
            int w = 1;
            g.setColor(Color.black);
            if (this.course.isValidControl(this.selectedSplit)) {
                g.fillRect(this.xPos[this.selectedSplit + 1] - w, this.yAxis.getMinPixel(), w, this.yAxis.getMaxPixel() - this.yAxis.getMinPixel());
            } else {
                int x = this.xPos[this.selectedSplit + 1] - w;
                y = this.yAxis.getMinPixel();
                while (y + 3 < this.yAxis.getMaxPixel()) {
                    g.fillRect(x, y, w, 3);
                    y += 6;
                }
            }
        }
    }

    protected Time getYFirst(Result result) {
        switch (this.graphType) {
            case 0: {
                return Time.ZEROTIME;
            }
            case 1: {
                return result.getStartTime();
            }
            case 2: {
                return Time.ZEROTIME;
            }
            case 3: {
                return Time.NULLTIME;
            }
            case 4: {
                return Time.NULLTIME;
            }
        }
        return Time.ZEROTIME;
    }

    protected Time getYTime(Result result, int split) {
        switch (this.graphType) {
            case 0: {
                return result.getTime(split).subtract(this.reference.getTime(split));
            }
            case 1: {
                return result.getAbsoluteTime(split);
            }
            case 2: {
                Time timeR = result.getSplitTime(split);
                Time timeRef = this.reference.getSplitTime(split);
                if (timeR.isValid() && timeRef.isValid() && timeRef.asSeconds() > 0) {
                    return new Time(timeR.asSeconds() * 6000 / timeRef.asSeconds() - 6000, true);
                }
                return Time.INVALIDTIME;
            }
            case 3: {
                return new Time(result.getTotalPos(split) * 60, result.getTotalPos(split) > 0);
            }
            case 4: {
                return new Time(result.getSplitPos(split) * 60, result.getSplitTime(split).isValid());
            }
        }
        return Time.INVALIDTIME;
    }

    protected String getRightText(Result result, int iSplit) {
        String pfx = result.isValid() ? " " : "*";
        StringBuffer s = new StringBuffer(String.valueOf(pfx) + result.getName(25));
        if (iSplit > -1) {
            int pos;
            if (this.showTotalTime) {
                if (this.graphType == 1) {
                    s.append("  " + result.getAbsoluteTime(iSplit).toString());
                    if (!result.getAbsoluteTime(iSplit).isValid()) {
                        return s.toString();
                    }
                } else {
                    s.append("  " + result.getTime(iSplit).toString());
                    if (!result.getTime(iSplit).isValid()) {
                        return s.toString();
                    }
                }
            }
            if (this.showTotalPos) {
                pos = result.getTotalPos(iSplit);
                if (pos > 0) {
                    s.append(" (" + new Integer(pos).toString() + ")");
                } else {
                    s.append(" (*)");
                }
            }
            if (this.showSplits && result.getSplitTime(iSplit).isValid()) {
                s.append("   " + result.getSplitTime(iSplit).toString());
            }
            if (this.showSplitPos && result.getSplitTime(iSplit).isValid()) {
                pos = result.getSplitPos(iSplit);
                if (result.getSplitTime(iSplit).isValid() && pos > 0) {
                    s.append(" (" + new Integer(pos).toString() + ")");
                } else {
                    s.append(" (*)");
                }
            }
            if (this.showTimeBehind && result.getSplitTime(iSplit).isValid() && this.reference.getSplitTime(iSplit).isValid()) {
                Time timeY;
                s.append("  " + result.getSplitTime(iSplit).subtract(this.reference.getSplitTime(iSplit)).toString());
                if (this.graphType == 2 && (timeY = this.getYTime(result, iSplit)).isValid()) {
                    s.append(" (" + timeY.asSeconds() / 60 + "%)");
                }
            }
        }
        return s.toString();
    }

    protected String getLeftText(Result result) {
        if (this.graphType == 1) {
            if (result.getStartTime() == null || !result.getStartTime().isValid()) {
                return String.valueOf(Message.get("Graph.NoStartTime")) + "  ";
            }
            String pfx = result.isValid() ? " " : "*";
            return String.valueOf(result.getStartTime().toString()) + " " + pfx + result.getName() + "  ";
        }
        return "";
    }

    protected void computeXPositions() {
        this.xPos[0] = this.xAxis.toPixel(0);
        int i = 0;
        while (i <= this.course.getNumControls()) {
            this.xPos[i + 1] = this.xAxis.toPixel(this.reference.getTime(i).asSeconds());
            ++i;
        }
        this.xPos[this.course.getNumControls() + 2] = 0x3FFFFFFF;
    }

    protected void computeGraphDimensions(Graphics g) {
        int maxTime;
        int minTime;
        this.dim = this.getSize();
        this.xAxis.setMinPixel(20 + this.getAxisWidth(g, this.LEFT_AXIS));
        this.xAxis.setMaxPixel(this.getSize().width - 10 - this.getAxisWidth(g, this.RIGHT_AXIS));
        this.yAxis.setMinPixel(25);
        this.yAxis.setMaxPixel(this.getSize().height - 30);
        if (displayedResults.size() == 0) {
            minTime = 0;
            maxTime = 1;
        } else {
            maxTime = 0;
            minTime = Time.MAXTIME.asSeconds();
            int i = 0;
            while (i < displayedResults.size()) {
                Result result = this.selectedResults.getResult((Integer)displayedResults.elementAt(i));
                Time time = this.getYFirst(result);
                if (time.isValid()) {
                    maxTime = Math.max(maxTime, time.asSeconds());
                    minTime = Math.min(minTime, time.asSeconds());
                }
                int splitCount = 0;
                while (splitCount <= this.course.getNumControls()) {
                    time = this.getYTime(result, splitCount);
                    if (time.isValid()) {
                        maxTime = Math.max(maxTime, time.asSeconds());
                        minTime = Math.min(minTime, time.asSeconds());
                    }
                    ++splitCount;
                }
                ++i;
            }
        }
        if (minTime == Time.MAXTIME.asSeconds()) {
            minTime = maxTime - 1;
        }
        this.yAxis.setMaxTime(new Time(maxTime));
        this.yAxis.setMinTime(new Time(minTime));
        this.xAxis.setMinTime(Time.ZEROTIME);
        this.xAxis.setMaxTime(this.reference.getTime(this.reference.getNumControls()));
        this.computeDimensions = false;
    }

    protected int getAxisWidth(Graphics g, int axis) {
        int MARGIN_WIDTH = 3;
        int MAX_TEXT_WIDTH = 300;
        int MIN_TEXT_WIDTH = 20;
        FontMetrics fontMetrics = g.getFontMetrics(g.getFont());
        int maxTextWidth = 0;
        if (this.selectedResults.getNumResults() == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.selectedResults.getNumResults()) {
            Result result = this.selectedResults.getResult(i);
            int w = axis == this.LEFT_AXIS ? fontMetrics.stringWidth(this.getLeftText(result)) : fontMetrics.stringWidth(this.getRightText(result, result.getNumControls())) + 20;
            maxTextWidth = Math.max(maxTextWidth, w);
            ++i;
        }
        return Math.max(MIN_TEXT_WIDTH, Math.min(maxTextWidth, MAX_TEXT_WIDTH));
    }

    private void showControlVisitors(Graphics g) {
        if (this.graphType == 1 || this.graphType == 0) {
            FontMetrics fontMetrics = g.getFontMetrics(g.getFont());
            int fontHeight = fontMetrics.getHeight();
            int width = 0;
            int i = 0;
            while (i < this.controlVisitors.length) {
                if (fontMetrics.stringWidth(this.controlVisitors[i]) > width) {
                    width = fontMetrics.stringWidth(this.controlVisitors[i]);
                }
                ++i;
            }
            int FRAMEWIDTH = 4;
            int yDraw = this.cvY - this.controlVisitors.length * fontHeight / 2 + 6;
            int boxHeight = this.controlVisitors.length * fontHeight + FRAMEWIDTH + FRAMEWIDTH;
            if (yDraw < this.yAxis.getMinPixel()) {
                yDraw = this.yAxis.getMinPixel();
            }
            if (yDraw + boxHeight > this.yAxis.getMaxPixel()) {
                yDraw = this.yAxis.getMaxPixel() - boxHeight;
            }
            g.setColor(new Color(0xFFFFE0));
            g.fillRect(this.cvX + 20 - FRAMEWIDTH, yDraw - fontHeight - FRAMEWIDTH + 2, width + FRAMEWIDTH + FRAMEWIDTH, boxHeight);
            g.setColor(new Color(0xFFF0A0));
            g.fillRect(this.cvX + 20 - FRAMEWIDTH, yDraw - fontHeight - FRAMEWIDTH + 2, width + FRAMEWIDTH + FRAMEWIDTH, fontHeight + FRAMEWIDTH);
            g.setColor(Color.black);
            g.drawRect(this.cvX + 20 - FRAMEWIDTH, yDraw - fontHeight - FRAMEWIDTH + 2, width + FRAMEWIDTH + FRAMEWIDTH, boxHeight);
            yDraw -= 3;
            int i2 = 0;
            while (i2 < this.controlVisitors.length) {
                String s = this.controlVisitors[i2];
                if (s.equals("")) {
                    g.setColor(Color.red);
                    g.fillRect(this.cvX + 21 - FRAMEWIDTH, yDraw - fontHeight + fontHeight / 2, width + FRAMEWIDTH + FRAMEWIDTH - 1, fontHeight * 3 + FRAMEWIDTH + FRAMEWIDTH - 2 - fontHeight / 2);
                } else {
                    if (s.endsWith("*")) {
                        g.setColor(Color.blue);
                        s = s.substring(0, s.length() - 1);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawString(s, this.cvX + 20, yDraw);
                }
                yDraw += fontHeight;
                if (i2 == 0) {
                    yDraw += 3;
                }
                ++i2;
            }
        }
    }

    private void showTimesAtControl(Graphics g) {
        int y = this.yAxis.toPixel(this.timesAtControl[0]);
        int x = this.xPos[this.selectedSplit + 1];
        int w = 2;
        g.setColor(Color.black);
        int i = 0;
        while (i < this.timesAtControl.length) {
            y = this.yAxis.toPixel(this.timesAtControl[i]);
            g.drawLine(x - w - 2, y, x + w, y);
            ++i;
        }
    }

    private boolean updateSelectedIndex(MouseEvent e) {
        int newSelectedSplit = -2;
        if (this.course != null) {
            int mouseX = e.getX();
            newSelectedSplit = this.selectedSplit;
            int xIndex = 0;
            while (xIndex <= this.course.getNumControls() + 1) {
                if (mouseX < (this.xPos[xIndex] + this.xPos[xIndex + 1]) / 2) {
                    newSelectedSplit = xIndex - 1;
                    break;
                }
                ++xIndex;
            }
        } else {
            newSelectedSplit = -2;
        }
        if (newSelectedSplit != this.selectedSplit) {
            this.selectedSplit = newSelectedSplit;
            return true;
        }
        return false;
    }

    private void setControlVisitors() {
        if (this.selectedSplit >= -1) {
            if (this.cvY < this.yAxis.getMinPixel()) {
                this.controlVisitors = this.cc.getCoursesForControlNo(this.course.getControlCode(this.selectedSplit));
                if (!this.course.isValidControl(this.selectedSplit)) {
                    String[] ncv = new String[this.controlVisitors.length + 3];
                    int i = this.controlVisitors.length - 1;
                    while (i >= 0) {
                        ncv[i] = this.controlVisitors[i];
                        --i;
                    }
                    ncv[this.controlVisitors.length] = "";
                    ncv[this.controlVisitors.length + 1] = Message.get("Graph.MouseInfo1");
                    ncv[this.controlVisitors.length + 2] = Message.get("Graph.MouseInfo2");
                    this.controlVisitors = ncv;
                }
            } else {
                this.controlVisitors = this.graphType == 1 ? this.cc.getTimesNear(this.yAxis.toTime(this.cvY), this.course.getControlCode(this.selectedSplit), this.selectedResults.getAgeClasses()) : (this.graphType == 0 ? this.cc.getFastestTimesForLeg(this.course.getControlCode(this.selectedSplit - 1), this.course.getControlCode(this.selectedSplit), this.selectedResults.getAgeClasses()) : new String[]{""});
            }
        } else {
            this.controlVisitors = new String[]{""};
        }
    }

    private void setTimesAtControl() {
        if (this.cvY < this.yAxis.getMinPixel()) {
            if (this.selectedSplit > -1 && this.selectedSplit < this.course.getNumControls()) {
                this.course.setValidControl(this.selectedSplit, !this.course.isValidControl(this.selectedSplit));
                this.course.invalidateSplitTimes();
                this.selectedResults.calcOptimumTimes();
                this.selectedResults.calcPositions();
                this.selectedResults.refreshReferenceResult();
            }
        } else {
            this.timesAtControl = this.selectedSplit >= -1 && this.graphType == 1 ? this.cc.getTimesAtControl(this.course.getControlCode(this.selectedSplit), this.yAxis.getMinTime(), this.yAxis.getMaxTime()) : null;
        }
    }

    private class LessThanResult
    implements ICompare {
        LessThanResult() {
        }

        public boolean lessThan(Object a, Object b) {
            return SplitsGraph.this.getDisplayedResult((Integer)a - 1).getSortTime().lessThan(SplitsGraph.this.getDisplayedResult((Integer)b - 1).getSortTime());
        }
    }

    private class MyListener
    extends MouseAdapter
    implements MouseMotionListener {
        MyListener() {
        }

        public void mouseMoved(MouseEvent e) {
            if (SplitsGraph.this.updateSelectedIndex(e)) {
                SplitsGraph.this.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            SplitsGraph.this.cvX = e.getX();
            SplitsGraph.this.cvY = e.getY();
            if ((e.getModifiers() & 4) == 4) {
                SplitsGraph.this.setTimesAtControl();
            }
            if ((e.getModifiers() & 0x10) == 16) {
                SplitsGraph.this.setControlVisitors();
            }
            SplitsGraph.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            SplitsGraph.this.cvX = e.getX();
            SplitsGraph.this.cvY = e.getY();
            SplitsGraph.this.updateSelectedIndex(e);
            if ((e.getModifiers() & 4) == 4) {
                SplitsGraph.this.setTimesAtControl();
            }
            if ((e.getModifiers() & 0x10) == 16) {
                SplitsGraph.this.setControlVisitors();
            }
            SplitsGraph.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            SplitsGraph.this.controlVisitors = null;
            SplitsGraph.this.timesAtControl = null;
            SplitsGraph.this.repaint();
        }
    }
}

