/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class SelectedResults {
    private Result[] results = new Result[0];
    private Result optimum = null;
    private Result winner25 = null;
    private Result winner50 = null;
    private Result winner75 = null;
    private Result winner100 = null;
    private Result reference = null;
    private int numControls = 0;
    private Vector ageClasses = new Vector(5);
    private int refNo = 0;
    private static LessThanResult lt = new LessThanResult();

    public void removeAll() {
        this.results = new Result[0];
        this.numControls = 0;
        this.ageClasses.removeAllElements();
    }

    public void addClass(AgeClass ageClass) {
        int size = this.results.length;
        Result[] newResults = new Result[size + ageClass.getNumResults()];
        int i = 0;
        while (i < size) {
            newResults[i] = this.results[i];
            ++i;
        }
        i = ageClass.getNumResults() - 1;
        while (i >= 0) {
            newResults[size + i] = ageClass.getResult(i);
            --i;
        }
        this.results = newResults;
        this.numControls = this.results[0].getNumControls();
        newResults = null;
        this.ageClasses.addElement(ageClass);
        ageClass.checkForInvalidControls();
    }

    public int getNumResults() {
        return this.results.length;
    }

    public Result getResult(int i) {
        return this.results[i];
    }

    public Result getReferenceResult() {
        return this.reference;
    }

    public void setReferenceResult(int refNo) {
        this.refNo = refNo;
        this.refreshReferenceResult();
    }

    public void refreshReferenceResult() {
        if (this.results.length == 0) {
            return;
        }
        switch (this.refNo) {
            case -5: {
                this.reference = this.optimum;
                break;
            }
            case -4: {
                this.reference = this.winner100;
                break;
            }
            case -3: {
                this.reference = this.winner75;
                break;
            }
            case -2: {
                this.reference = this.winner50;
                break;
            }
            case -1: {
                this.reference = this.winner25;
                break;
            }
            default: {
                this.reference = new Result(this.results[this.refNo]);
            }
        }
        int lastValidTime = 0;
        int i = 0;
        while (i < this.numControls) {
            Time time = this.reference.getTime(i);
            if (time.isValid() && time.asSeconds() != lastValidTime) {
                lastValidTime = time.asSeconds();
                ++i;
                continue;
            }
            boolean found = false;
            int j = i + 1;
            while (j <= this.numControls && !found) {
                if (this.reference.getTime(j).isValid()) {
                    found = true;
                    continue;
                }
                ++j;
            }
            int nextValidTime = found ? this.reference.getTime(j).asSeconds() : lastValidTime + (j - i + 1) * 60;
            int k = i;
            while (k < j) {
                this.reference.setTime(k, (nextValidTime - lastValidTime) * (k - i + 1) / (j - i + 1) + lastValidTime, false);
                ++k;
            }
            i = j;
        }
    }

    public Vector getAgeClasses() {
        return this.ageClasses;
    }

    public void calcOptimumTimes() {
        if (this.results.length == 0) {
            return;
        }
        Course course = this.results[0].getCourse();
        this.optimum = new Result(this.numControls, course);
        this.winner25 = new Result(this.numControls, course);
        this.winner50 = new Result(this.numControls, course);
        this.winner75 = new Result(this.numControls, course);
        this.winner100 = new Result(this.numControls, course);
        Time accumulatedBestSplits = new Time(0, true);
        int lastValidControl = -1;
        int i = 0;
        while (i <= this.numControls) {
            if (course.isValidControl(i)) {
                Time currentMin = Time.MAXTIME;
                int j = 0;
                while (j < this.results.length) {
                    Time time = this.results[j].getTime(i).subtract(this.results[j].getTime(lastValidControl));
                    if (time.isValid() && time.lessThan(currentMin) && time.asSeconds() > 0) {
                        currentMin = time;
                    }
                    ++j;
                }
                if (currentMin != Time.MAXTIME) {
                    accumulatedBestSplits = accumulatedBestSplits.add(currentMin);
                    accumulatedBestSplits.setValid(true);
                    lastValidControl = i;
                } else {
                    accumulatedBestSplits.setValid(false);
                }
            } else {
                accumulatedBestSplits.setValid(false);
            }
            this.optimum.setTime(i, accumulatedBestSplits);
            Time winner = this.results[0].getTime(i);
            this.winner25.setTime(i, (int)Math.min((double)winner.asSeconds() * 1.25, (double)Time.MAXTIME.asSeconds()), winner.isValid());
            this.winner50.setTime(i, (int)Math.min((double)winner.asSeconds() * 1.5, (double)Time.MAXTIME.asSeconds()), winner.isValid());
            this.winner75.setTime(i, (int)Math.min((double)winner.asSeconds() * 1.75, (double)Time.MAXTIME.asSeconds()), winner.isValid());
            this.winner100.setTime(i, (int)Math.min((double)winner.asSeconds() * 2.0, (double)Time.MAXTIME.asSeconds()), winner.isValid());
            ++i;
        }
        this.optimum.setValid(accumulatedBestSplits.isValid());
        this.winner25.setValid(this.results[0].isValid());
        this.winner50.setValid(this.results[0].isValid());
        this.winner75.setValid(this.results[0].isValid());
        this.winner100.setValid(this.results[0].isValid());
    }

    public void calcPositions() {
        int lastPos;
        Time lastTime;
        int i;
        if (this.results.length == 0) {
            return;
        }
        int numControls = this.results[0].getNumControls();
        Course course = this.results[0].getCourse();
        int j = 0;
        while (j <= numControls) {
            if (course.isValidControl(j)) {
                i = this.results.length - 1;
                while (i >= 0) {
                    if (this.results[i].getSplitTime(j).isValid()) {
                        this.results[i].setSortTime(this.results[i].getSplitTime(j));
                    } else {
                        this.results[i].setSortTime(Time.MAXTIME);
                    }
                    --i;
                }
                Sorter.Sort(this.results, 0, this.results.length - 1, lt);
                lastTime = Time.ZEROTIME;
                lastPos = 1;
                i = 0;
                while (i < this.results.length) {
                    if (!this.results[i].getSortTime().isValid()) {
                        this.results[i].setSplitPos(j, -1);
                    } else if (this.results[i].getSortTime().asSeconds() == lastTime.asSeconds()) {
                        this.results[i].setSplitPos(j, lastPos);
                    } else {
                        this.results[i].setSplitPos(j, i + 1);
                        lastPos = i + 1;
                        lastTime = this.results[i].getSortTime();
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.results.length) {
                    this.results[i].setSplitPos(j, -1);
                    ++i;
                }
            }
            ++j;
        }
        int i2 = this.results.length - 1;
        while (i2 >= 0) {
            this.results[i2].setSortTime(Time.ZEROTIME);
            --i2;
        }
        j = 0;
        while (j <= numControls) {
            i = this.results.length - 1;
            while (i >= 0) {
                if (!this.results[i].getSortTime().isValid() && !this.results[i].isValid() || !this.results[i].getTime(j).isValid()) {
                    this.results[i].setSortTime(Time.INVALIDTIME);
                } else {
                    this.results[i].setSortTime(this.results[i].getTime(j));
                }
                --i;
            }
            Sorter.Sort(this.results, 0, this.results.length - 1, lt);
            lastTime = Time.ZEROTIME;
            lastPos = 1;
            i = 0;
            while (i < this.results.length) {
                if (this.results[i].getSortTime().isValid()) {
                    if (this.results[i].getSortTime().asSeconds() == lastTime.asSeconds()) {
                        this.results[i].setTotalPos(j, lastPos);
                    } else {
                        this.results[i].setTotalPos(j, i + 1);
                        lastPos = i + 1;
                        lastTime = this.results[i].getSortTime();
                    }
                } else {
                    this.results[i].setTotalPos(j, -1);
                }
                ++i;
            }
            ++j;
        }
    }

    public void sortByFinishTime() {
        if (this.results.length == 0) {
            return;
        }
        int numControls = this.results[0].getNumControls();
        int i = this.results.length - 1;
        while (i >= 0) {
            this.results[i].setSortTime(this.results[i].getTime(numControls));
            if (!this.results[i].isValid()) {
                this.results[i].setSortTime(Time.MAXTIME);
            }
            --i;
        }
        Sorter.Sort(this.results, 0, this.results.length - 1, lt);
    }

    private static class LessThanResult
    implements ICompare {
        LessThanResult() {
        }

        public boolean lessThan(Object a, Object b) {
            return ((Result)a).getSortTime().asSeconds() < ((Result)b).getSortTime().asSeconds();
        }
    }
}

