/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SIEventLoader
extends EventLoader {
    private int debugLevel = 0;
    private String FinishSymbols = "~A~F~Z~M~C~";
    private String NumControlSymbols = "~C~P~K~";
    private String DsqSymbols = "~pm~mp~dnf~Felst.~Fehlst~Aufg~disk~Disk~Disqu~disqu";
    private String NonCompSymbols = "~nc~aK~NC~AK~";
    private String KmSymbols = "~km~m~Km~";
    private String ClimbSymbols = "~Cm~Hm~hm~m~";
    private static final int ST_INITIAL = 0;
    private static final int ST_WAIT_FOR_CONTROLS_LIST = 1;
    private static final int ST_WAIT_FOR_RESULT_FIRST_LINE = 2;
    private static final int ST_WAIT_FOR_RESULT_SECOND_LINE = 3;
    private static final int ST_WAIT_FOR_RESULT_FIRST_CONTINUATION_LINE = 4;
    private static final int ST_WAIT_FOR_RESULT_SECOND_CONTINUATION_LINE = 5;
    private static final int RT_NORMAL = 0;
    private static final int RT_FULL = 1;
    private static final int SR_BYSTARTNO = 0;
    private static final int SR_BYNAME = 1;
    private static final String[] stringTT = new String[]{"STRING", "FLOAT", "INT", "TIME", "DISTANCE_UNIT", "CLIMB_UNIT", "N_CONTR", "N_COMP", "CC", "FINISH_SYMBOL", "NON_CMP", "MISPUNCH"};
    private static final String[] stringLT = new String[]{"LT_UNKNOWN", "LT_COURSE_HEADER", "LT_COURSE_INFO", "LT_COMP_FIRST", "NC_FIRST", "DSQ_FIRST", "LT_COMP_SECOND", "COMP_SUBSEQ", "LT_COMP_STARTTIME"};
    private static final String[] stringST = new String[]{"ST_INITIAL", "ST_WAIT_FOR_CONTROLS_LIST", "ST_WAIT_FOR_RESULT_FIRST_LINE", "ST_WAIT_FOR_RESULT_SECOND_LINE", "ST_WAIT_FOR_RESULT_FIRST_CONTINUATION_LINE", "ST_WAIT_FOR_RESULT_SECOND_CONTINUATION_LINE"};
    private String fileName;
    private String fileNameStartTimes;
    private BufferedReader reader;
    private int starttimeColumn;
    private int line = 0;
    private String st = "";
    private String stOld = "";
    private int byCourse;
    private Tokenizer tokenList = new Tokenizer();
    private Result result;
    private Course course = null;
    private AgeClass ageClass = null;
    private Time[] splits = null;
    private int numberOfControlsForCourse = 0;
    private int currentSplitNumber;
    private int state = 0;
    private String courseName;
    private boolean validRun;
    private int resultsType = 0;
    private int startnoRef = -1;
    private boolean firstCompPerClass;
    private int doubleRowsPerResult = 0;
    private int doubleRowsRead = 0;
    private Time minStartTime = new Time(Time.MAXTIME.asSeconds());
    private Time maxStartTime = new Time(0);
    private int nRunners = 0;

    public SIEventLoader(OEvent newEvent, String newSISymbols, String newFilenameStartTimes, int newStarttimeColumn) throws Exception {
        this.Event = newEvent;
        if (newSISymbols != null) {
            StringTokenizer sT = new StringTokenizer(newSISymbols, ";");
            if (sT.countTokens() != 6) {
                throw new Exception(String.valueOf(Message.get("SILoader.BadSiSymbols", sT.countTokens())) + newSISymbols);
            }
            this.FinishSymbols = "~" + sT.nextToken() + "~";
            this.DsqSymbols = "~" + sT.nextToken() + "~";
            this.NonCompSymbols = "~" + sT.nextToken() + "~";
            this.NumControlSymbols = "~" + sT.nextToken() + "~";
            this.KmSymbols = "~" + sT.nextToken() + "~";
            this.ClimbSymbols = "~" + sT.nextToken() + "~";
        }
        this.fileNameStartTimes = newFilenameStartTimes;
        this.starttimeColumn = newStarttimeColumn;
    }

    public void loadEvent(String newFileName, boolean urlInput, boolean zipped, int newbyCourse) throws IOException, Exception {
        this.byCourse = newbyCourse;
        this.fileName = newFileName;
        this.loadResults(urlInput, zipped);
        if ((this.debugLevel & 0x80) == 128) {
            new Debug(this.Event).listAll();
        }
        if (!this.fileNameStartTimes.equals("")) {
            this.loadStartTimes(urlInput, zipped);
            if ((this.debugLevel & 0x8000) == 32768) {
                new Debug(this.Event).listAll();
            }
        } else {
            System.out.println(Message.get("SILoader.NoStartTimes"));
        }
        System.out.println(String.valueOf(this.nRunners) + " runners");
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    private void loadResults(boolean urlInput, boolean zipped) throws Exception {
        System.out.println("[loadResults] " + Message.get("SILoader.LoadingResults", this.fileName));
        try {
            this.reader = this.openReader(this.fileName, urlInput, zipped);
        }
        catch (IOException e) {
            throw new Exception(String.valueOf(e.getMessage()) + "\n");
        }
        this.line = 0;
        this.state = 0;
        try {
            try {
                this.stOld = this.st;
                this.st = this.getLine(this.reader);
                if (this.st == null) {
                    this.fatalError(Message.get("SILoader.NoData"));
                }
                while (this.st != null && this.st.trim() != null) {
                    this.tokenList.splitIntoTokens(this.st);
                    int linet = this.tokenList.lineType();
                    if ((this.debugLevel & 1) == 1) {
                        System.out.println("[loadEvent][" + this.line + "] State (before)=" + stringST[this.state - 0] + "  Linetype:=" + stringLT[linet] + " >> " + this.st);
                    }
                    if ((this.debugLevel & 2) == 2) {
                        this.tokenList.printTokentypes();
                    }
                    switch (linet) {
                        case 1: {
                            this.courseHeader();
                            break;
                        }
                        case 2: {
                            this.courseInfo();
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            this.compFirst();
                            break;
                        }
                        case 6: {
                            this.compSecond();
                            break;
                        }
                        case 7: {
                            this.compMultipleLines();
                            break;
                        }
                        case 0: {
                            this.unknownLine();
                        }
                    }
                    this.stOld = this.st;
                    this.st = this.getLine(this.reader);
                }
            }
            catch (Exception e) {
                this.tokenList.printTokentypes();
                throw new Exception("\n" + Message.get("SILoader.Error") + e.getMessage() + "\n" + "  [" + new Integer(this.line).toString() + "] " + this.st + "\n" + "  [" + new Integer(this.line - 1).toString() + "] " + this.stOld + "\n");
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.reader.close();
            throw throwable;
        }
        Object var4_8 = null;
        this.reader.close();
        if (this.Event.getName().equals("")) {
            System.out.println(Message.get("SILoader.Eventname"));
        }
    }

    private void parseCourseHeader() {
        int tNum = this.tokenList.getNumberOfTokens() - 1;
        this.numberOfControlsForCourse = 0;
        String courseClimb = null;
        String courseLength = null;
        if (this.tokenList.typeAt(tNum) == 2) {
            if (Integer.parseInt(this.tokenList.stringAt(tNum)) <= 30) {
                this.numberOfControlsForCourse = Integer.parseInt(this.tokenList.stringAt(tNum--));
            } else {
                courseClimb = this.tokenList.stringAt(tNum--);
            }
        }
        while (tNum > 1) {
            switch (this.tokenList.typeAt(tNum)) {
                case 6: {
                    this.numberOfControlsForCourse = Integer.parseInt(this.tokenList.stringAt(--tNum));
                    break;
                }
                case 5: {
                    courseClimb = this.tokenList.stringAt(--tNum);
                    break;
                }
                case 4: {
                    courseLength = this.tokenList.stringAt(--tNum);
                }
            }
            --tNum;
        }
        tNum = 0;
        this.courseName = "";
        while (this.tokenList.typeAt(tNum) != 1 && this.tokenList.typeAt(tNum) != 7 && tNum < this.tokenList.getNumberOfTokens()) {
            this.courseName = this.courseName.concat(" ").concat(this.tokenList.stringAt(tNum++)).trim();
        }
        this.courseName = HTMLutils.translateString(this.courseName);
        this.course = new Course(this.courseName, this.numberOfControlsForCourse, courseLength, courseClimb);
        if (this.byCourse == 0) {
            this.course.setName("");
            this.ageClass = new AgeClass(this.courseName);
        } else {
            this.ageClass = null;
        }
    }

    private void courseHeader() throws Exception {
        if (this.state == 5 || this.state == 4) {
            this.reportMissingTimes();
            this.result.addMissingTimes();
            this.state = 2;
        }
        if (this.state == 2 || this.state == 0) {
            this.parseCourseHeader();
            this.numberOfControlsForCourse = 0;
            this.firstCompPerClass = true;
            if ((this.debugLevel & 4) == 4) {
                System.out.println("\n[courseHeader] " + this.course.getName() + " courseLength: " + this.course.getDistance() + " / courseClimb: " + this.course.getClimb() + " / nContr: " + this.course.getNumControls());
            }
            this.state = 1;
        } else {
            this.fatalError(Message.get("SILoader.UnexpectedCourseHeader"));
        }
    }

    private void courseInfo() throws Exception {
        if (this.state == 1) {
            int tokenListSize = this.tokenList.getNumberOfTokens();
            int i = 0;
            while (i < tokenListSize) {
                String cc = this.tokenList.stringAt(i);
                int start = 0;
                int len = cc.length();
                while (start < len && cc.charAt(start) != '(') {
                    ++start;
                }
                int end = ++start;
                while (end < len && cc.charAt(end) != ')') {
                    ++end;
                }
                if (start < len && end < len) {
                    this.course.addControlCode(this.numberOfControlsForCourse + i + 1, cc.substring(start, end));
                }
                ++i;
            }
            if (this.tokenList.typeAt(tokenListSize - 1) == 9 || this.numberOfControlsForCourse + tokenListSize - 1 == this.course.getNumControls()) {
                --this.numberOfControlsForCourse;
                this.course = this.Event.addCourse(this.course);
                if (this.byCourse == 0) {
                    this.ageClass = this.course.addAgeClass(this.ageClass);
                }
                this.state = 2;
            }
            this.numberOfControlsForCourse += tokenListSize;
            if (this.state == 2 && this.numberOfControlsForCourse != this.course.getNumControls()) {
                throw new Exception(Message.get("SILoader.WrongNoControls", this.course.getName(), this.course.getNumControls()));
            }
        } else {
            this.fatalError(Message.get("SILoader.UnexpectedCourseHeader"));
        }
    }

    private boolean processSplitTimes(int startAt) throws Exception {
        if (this.firstCompPerClass) {
            ++this.doubleRowsPerResult;
        } else {
            ++this.doubleRowsRead;
        }
        boolean allTimesInvalid = true;
        while (startAt < this.tokenList.getNumberOfTokens() && this.currentSplitNumber <= this.numberOfControlsForCourse) {
            boolean voidControl = false;
            this.splits[this.currentSplitNumber] = new Time(this.tokenList.stringAt(startAt));
            if (this.currentSplitNumber > 0 && this.splits[this.currentSplitNumber].isValid() && this.splits[this.currentSplitNumber - 1].isValid() && this.splits[this.currentSplitNumber].lessThan(this.splits[this.currentSplitNumber - 1])) {
                this.splits[this.currentSplitNumber] = this.splits[this.currentSplitNumber].add(new Time(3600));
            }
            if (!this.tokenList.stringAt(startAt).startsWith("-")) {
                allTimesInvalid = false;
            }
            if (!this.splits[this.currentSplitNumber].isValid()) {
                if (this.splits[this.currentSplitNumber].asSeconds() == 0) {
                    voidControl = true;
                } else {
                    this.validRun = false;
                    this.result.setValid(false);
                }
            }
            ++this.currentSplitNumber;
            ++startAt;
            if (this.resultsType != 1 || !this.validRun || this.currentSplitNumber > this.numberOfControlsForCourse || voidControl) continue;
            if (startAt < this.tokenList.getNumberOfTokens() - 1 && this.tokenList.typeAt(startAt) == 7 && this.tokenList.typeAt(startAt + 1) == 3) {
                startAt += 2;
                continue;
            }
            if (startAt < this.tokenList.getNumberOfTokens() && this.tokenList.typeAt(startAt) != 3) {
                this.fatalError(Message.get("SILoader.MissingTime", this.currentSplitNumber));
            }
            if (++startAt < this.tokenList.getNumberOfTokens() && this.tokenList.typeAt(startAt) != 7) {
                --startAt;
                this.validRun = false;
                this.result.setValid(false);
                continue;
            }
            ++startAt;
        }
        return !allTimesInvalid;
    }

    private void compFirst() throws Exception {
        if (this.state == 2 || this.state == 5 || this.state == 4) {
            if (this.firstCompPerClass) {
                this.doubleRowsPerResult = 0;
            } else {
                this.doubleRowsRead = 0;
            }
            boolean misPunch = false;
            String misPunchToken = "";
            if (this.state == 5 || this.state == 4) {
                this.reportMissingTimes();
                this.result.addMissingTimes();
            }
            int firstTime = this.tokenList.getNumberOfTokens() - 1;
            this.validRun = true;
            while (this.tokenList.typeAt(firstTime) == 3 || this.resultsType == 1 && this.tokenList.typeAt(firstTime) == 7) {
                --firstTime;
            }
            if (this.tokenList.typeAt(firstTime) == 11) {
                misPunchToken = " (" + this.tokenList.stringAt(firstTime) + ")";
                --firstTime;
                misPunch = true;
            }
            this.splits = new Time[this.course.getNumControls() + 1];
            this.currentSplitNumber = 0;
            if (this.byCourse > 0) {
                this.ageClass = this.course.addAgeClass(new AgeClass(this.tokenList.stringAt(firstTime--)));
            }
            int firstNameIndex = 0;
            while (this.tokenList.typeAt(firstNameIndex) == 2 || this.tokenList.typeAt(firstNameIndex) == 10) {
                ++firstNameIndex;
            }
            if (this.startnoRef == -1 && this.tokenList.typeAt(0) == 2 && !misPunch) {
                this.startnoRef = this.tokenList.typeAt(1) != 2 ? 1 : 0;
            }
            int startNumber = -1;
            if (this.startnoRef == 0 && firstNameIndex > 0 && this.tokenList.typeAt(firstNameIndex - 1) == 2) {
                startNumber = Integer.parseInt(this.tokenList.stringAt(firstNameIndex - 1));
            }
            String competitorName = this.tokenList.stringAt(firstNameIndex);
            int i = firstNameIndex + 1;
            while (i <= firstTime) {
                competitorName = competitorName.concat(" ").concat(this.tokenList.stringAt(i)).trim();
                ++i;
            }
            if (this.tokenList.typeAt(0) == 10) {
                competitorName = this.tokenList.stringAt(0).concat(" ").concat(competitorName);
            }
            competitorName = HTMLutils.translateString(competitorName);
            this.result = new Result(competitorName, "", this.course, this.ageClass, this.splits, null, startNumber, this.validRun && !misPunch);
            ++this.nRunners;
            if (this.tokenList.typeAt(0) == 10) {
                this.result.setValid(false);
            }
            if (this.byCourse > 0) {
                ++firstTime;
            }
            if (this.processSplitTimes(firstTime + 2)) {
                this.state = 3;
            }
        } else {
            this.fatalError(Message.get("SILoader.MissingCourse"));
        }
    }

    private void compSecond() throws Exception {
        if (this.state == 3) {
            String club = this.tokenList.stringAt(0);
            int i = 1;
            int size = this.tokenList.getNumberOfTokens();
            while (i < size && this.tokenList.typeAt(i) != 3) {
                club = club.concat(" ").concat(this.tokenList.stringAt(i));
                ++i;
            }
            club = HTMLutils.translateString(club);
            this.result.setClub(club);
            this.ageClass.addResult(this.result);
            if (this.currentSplitNumber < this.course.getNumControls() + 1) {
                this.state = 4;
                if (!this.firstCompPerClass && this.doubleRowsRead >= this.doubleRowsPerResult) {
                    this.reportMissingTimes();
                    this.result.addMissingTimes();
                    this.state = 2;
                }
            } else {
                this.firstCompPerClass = false;
                this.state = 2;
            }
        } else if (this.state != 0 && this.state != 2) {
            this.fatalError(Message.get("SILoader.MissingFirstLine"));
        }
    }

    private void compMultipleLines() throws Exception {
        int tokensSize = this.tokenList.getNumberOfTokens();
        if (this.state == 4) {
            if (this.processSplitTimes(0)) {
                this.state = 5;
            }
        } else if (this.state == 5) {
            if (this.currentSplitNumber <= this.course.getNumControls()) {
                this.state = 4;
                if (!this.firstCompPerClass && this.doubleRowsRead >= this.doubleRowsPerResult) {
                    this.reportMissingTimes();
                    this.result.addMissingTimes();
                    this.state = 2;
                }
            } else {
                this.state = 2;
            }
        }
    }

    private void unknownLine() throws Exception {
        if (this.state != 0) {
            this.fatalError(Message.get("SILoader.UnknownLine", this.line));
        }
    }

    private void loadStartTimes(boolean urlInput, boolean zipped) throws Exception {
        if (this.fileNameStartTimes.equals("")) {
            return;
        }
        this.reader = this.openReader(this.fileNameStartTimes, urlInput, zipped);
        System.out.println("[loadStartTimes] " + Message.get("SILoader.LoadingStartTimes", this.fileNameStartTimes));
        switch (this.startnoRef) {
            case -1: {
                System.out.println("Internal Error: startnoRef not set.");
                break;
            }
            case 0: {
                System.out.println(Message.get("SILoader.StartnoByNumber"));
                break;
            }
            case 1: {
                System.out.println(Message.get("SILoader.StartnoByName"));
            }
        }
        this.line = 0;
        this.st = "";
        this.course = null;
        this.ageClass = null;
        try {
            try {
                this.st = this.getLine(this.reader);
                if (this.st == null) {
                    this.fatalError(Message.get("SILoader.NoData"));
                }
                while (this.st != null && this.st.trim() != null) {
                    if ((this.debugLevel & 0x100) == 256) {
                        System.out.println("[loadStartTimes] " + this.st);
                    }
                    this.tokenList.splitIntoTokens(this.st);
                    if (this.st.charAt(0) > ' ') {
                        if ((this.debugLevel & 0x200) == 512) {
                            this.tokenList.printTokentypes();
                        }
                        if (this.tokenList.lineType() == 1) {
                            this.startListCourseHeader();
                        }
                    } else {
                        if ((this.debugLevel & 0x200) == 512) {
                            this.tokenList.printTokentypes();
                        }
                        if (this.tokenList.getNumberOfTokens() > 2 && (this.tokenList.typeAt(0) == 2 && (this.tokenList.typeAt(this.tokenList.getNumberOfTokens() - 1) == 3 || this.tokenList.typeAt(this.tokenList.getNumberOfTokens() - 1) == 2) || this.tokenList.typeAt(0) == 3)) {
                            this.startListAddStartTime();
                        }
                    }
                    this.st = this.getLine(this.reader);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Message.get("SILoader.StartlistError")) + this.fileNameStartTimes + "\n" + e.toString() + "\n" + "Line " + new Integer(this.line).toString() + ": " + this.st + "\n");
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.reader.close();
            throw throwable;
        }
        Object var4_6 = null;
        this.reader.close();
        if (this.maxStartTime.subtract(this.minStartTime).asSeconds() < 600) {
            this.multiplyStartTimesBy60();
        }
    }

    private void startListCourseHeader() {
        this.parseCourseHeader();
        if (this.ageClass != null) {
            this.ageClass = this.Event.findAgeClass(this.ageClass);
        }
        if (this.ageClass != null) {
            this.course = null;
            return;
        }
        if (this.course != null) {
            this.course = this.Event.findCourse(this.course.getName());
        }
    }

    private void startListAddStartTime() throws Exception {
        int startNumber;
        String strStartTime;
        int last = this.tokenList.getNumberOfTokens() - 1;
        this.result = null;
        if (this.startnoRef == 0 && this.tokenList.typeAt(0) == 3 && this.tokenList.typeAt(1) == 2) {
            strStartTime = this.tokenList.stringAt(0);
            startNumber = Integer.parseInt(this.tokenList.stringAt(1));
            this.result = this.Event.findResult(startNumber);
            if (this.result == null) {
                return;
            }
        } else {
            if (this.startnoRef == 0) {
                if (this.tokenList.typeAt(0) != 2) {
                    System.out.println(Message.get("SILoader.MissingStartNumber", this.line));
                    return;
                }
                startNumber = Integer.parseInt(this.tokenList.stringAt(0));
                if (this.ageClass != null) {
                    this.result = this.ageClass.findResult(startNumber);
                } else if (this.course != null) {
                    this.result = this.course.findResult(startNumber);
                }
                if (this.result == null) {
                    this.result = this.Event.findResult(startNumber);
                }
            }
            if (this.result == null) {
                int firstNameIndex = 0;
                String competitorName = "";
                while (firstNameIndex <= last && this.tokenList.typeAt(firstNameIndex) == 2) {
                    ++firstNameIndex;
                }
                competitorName = this.tokenList.stringAt(firstNameIndex++);
                while (firstNameIndex <= last && this.tokenList.typeAt(firstNameIndex) == 0) {
                    competitorName = String.valueOf(competitorName) + " " + this.tokenList.stringAt(firstNameIndex++);
                }
                if (this.ageClass != null) {
                    this.result = this.ageClass.findResult(competitorName);
                } else if (this.course != null) {
                    this.result = this.course.findResult(competitorName);
                }
                if (this.result == null) {
                    this.result = this.Event.findResult(competitorName);
                }
            }
            if (this.result == null) {
                return;
            }
            if (this.starttimeColumn > 0) {
                this.st = HTMLutils.translateString(this.st);
                int startCol = this.starttimeColumn;
                if (this.st.charAt(startCol) == ' ') {
                    ++startCol;
                }
                if (this.st.charAt(startCol) == ' ') {
                    ++startCol;
                }
                int endCol = startCol + 1;
                while (endCol < this.st.length() && this.st.charAt(endCol) > ' ') {
                    ++endCol;
                }
                strStartTime = this.st.substring(startCol, endCol);
            } else {
                strStartTime = this.tokenList.stringAt(last);
                if (this.tokenList.typeAt(last) == 2) {
                    strStartTime = String.valueOf(strStartTime) + ":00";
                }
            }
        }
        Time startTime = new Time(strStartTime);
        this.result.setStartTime(startTime);
        if ((this.debugLevel & 0x400) == 1024) {
            System.out.println("Found starttime " + (this.startnoRef == 1 ? "by name" : "by number") + " using " + (this.ageClass != null ? " ageclass [" + this.ageClass.getName() + "]" : (this.course != null ? " course [" + this.course.getName() + "]" : " full search of all courses/ageclasses")) + " for " + this.result.getName() + "/" + startTime.toString());
        }
        if (startTime.lessThan(this.minStartTime)) {
            this.minStartTime.setSeconds(startTime.asSeconds());
        }
        if (this.maxStartTime.lessThan(startTime)) {
            this.maxStartTime.setSeconds(startTime.asSeconds());
        }
    }

    private void multiplyStartTimesBy60() {
        int nC = 0;
        while (nC < this.Event.getNumCourses()) {
            Course course = this.Event.getCourse(nC);
            int nA = 0;
            while (nA < course.getNumAgeClasses()) {
                AgeClass ageClass = course.getAgeClass(nA);
                int nR = 0;
                while (nR < ageClass.getNumResults()) {
                    Result result = ageClass.getResult(nR);
                    if (result.getStartTime() != null && result.getStartTime().isValid()) {
                        result.setStartTimeAsSeconds(result.getStartTime().asSeconds() * 60);
                    }
                    ++nR;
                }
                ++nA;
            }
            ++nC;
        }
    }

    private void fatalError(String s) throws Exception {
        this.tokenList.printTokentypes();
        new Debug(this.Event).listAll();
        throw new Exception(String.valueOf(s) + "\n" + this.st);
    }

    private void reportMissingTimes() {
        System.out.println(Message.get("SILoader.MissingTimes", String.valueOf(this.ageClass.getName()) + ":" + this.result.getName(), this.line));
    }

    private String getLine(BufferedReader reader) throws IOException {
        String buffer;
        do {
            buffer = reader.readLine();
            ++this.line;
            if (buffer != null) continue;
            return buffer;
        } while ((buffer = this.StripHTMLTags(buffer, reader)).trim().length() == 0);
        return buffer;
    }

    private String StripHTMLTags(String buffer, BufferedReader reader) throws IOException {
        int tagStart;
        while ((tagStart = buffer.indexOf("<")) != -1) {
            try {
                int ofs;
                String afterTag;
                int tagEnd;
                while ((tagEnd = buffer.indexOf(">", tagStart)) == -1) {
                    buffer = buffer.concat(" ".concat(reader.readLine()));
                    ++this.line;
                }
                String beforeTag = tagStart > 0 ? buffer.substring(0, tagStart) : "";
                String string = afterTag = tagEnd < buffer.length() ? buffer.substring(tagEnd + 1, buffer.length()) : "";
                if (this.Event.getName().equals("") && this.line < 30 && (ofs = buffer.toLowerCase().indexOf("td><nobr><b>")) != -1) {
                    int headerEnd = buffer.indexOf("<", ofs + 13);
                    if (headerEnd > 0) {
                        this.Event.setName(buffer.substring(ofs + 13, headerEnd));
                    } else {
                        this.Event.setName(buffer.substring(ofs + 13));
                    }
                }
                buffer = beforeTag.concat(afterTag);
            }
            catch (Exception e) {
                throw new IOException(Message.get("SILoader.HTMLError"));
            }
        }
        return buffer;
    }

    private class Tokenizer {
        private Vector tokens = new Vector(40, 10);
        public static final int LT_UNKNOWN = 0;
        public static final int LT_COURSE_HEADER = 1;
        public static final int LT_COURSE_INFO = 2;
        public static final int LT_COMP_FIRST = 3;
        public static final int LT_NONCOMP_FIRST = 4;
        public static final int LT_DSQ_FIRST = 5;
        public static final int LT_COMP_SECOND = 6;
        public static final int LT_COMP_SUBSQ = 7;
        public static final int LT_COMP_STARTTIME = 8;
        public static final int TT_STRING = 0;
        public static final int TT_FLOAT = 1;
        public static final int TT_INTEGER = 2;
        public static final int TT_TIME = 3;
        public static final int TT_DISTANCE_UNIT = 4;
        public static final int TT_CLIMB_UNIT = 5;
        public static final int TT_NUM_CONTROLS = 6;
        public static final int TT_NUM_COMPETITORS = 7;
        public static final int TT_CONTROL_CODE = 8;
        public static final int TT_FINISH_SYMBOL = 9;
        public static final int TT_NON_COMP = 10;
        public static final int TT_MISPUNCH = 11;

        Tokenizer() {
        }

        public void splitIntoTokens(String buffer) {
            int start = 0;
            boolean notDone = true;
            this.tokens.removeAllElements();
            while (start < buffer.length() && notDone) {
                Token t = this.sub(buffer, start);
                if (t.value != "") {
                    this.tokens.addElement(t);
                    start = t.end;
                    continue;
                }
                notDone = false;
            }
        }

        public int getNumberOfTokens() {
            return this.tokens.size();
        }

        public int lineType() {
            int last = SIEventLoader.this.tokenList.getNumberOfTokens() - 1;
            int firstType = SIEventLoader.this.tokenList.typeAt(0);
            int lastType = SIEventLoader.this.tokenList.typeAt(last);
            if (last >= 1 && lastType == 6 && SIEventLoader.this.tokenList.typeAt(last - 1) == 2 || lastType == 4 || lastType == 5 || lastType == 7 && SIEventLoader.this.tokenList.typeAt(last - 1) != 3) {
                return 1;
            }
            if (last > 3 && lastType == 2 && (SIEventLoader.this.tokenList.typeAt(last - 1) == 5 || SIEventLoader.this.tokenList.typeAt(last - 1) == 4)) {
                return 1;
            }
            if (last >= 1 && SIEventLoader.this.tokenList.typeAt(last - 1) == 8 || last == 0 && lastType == 9) {
                return 2;
            }
            if (this.isDisqualified()) {
                return 5;
            }
            if (last >= 2 && firstType == 2 && lastType == 3 && SIEventLoader.this.state != 0) {
                return 3;
            }
            if (last >= 2 && lastType == 7 && SIEventLoader.this.tokenList.typeAt(last - 1) == 3) {
                SIEventLoader.this.resultsType = 1;
                if (firstType == 3) {
                    return 7;
                }
                if (SIEventLoader.this.state == 3) {
                    return 6;
                }
                return 3;
            }
            if (last >= 0 && firstType == 10) {
                return 4;
            }
            if (last >= 0 && firstType == 0) {
                return 6;
            }
            if (firstType == 3) {
                return 7;
            }
            return 0;
        }

        public int startListLineType() {
            return 0;
        }

        private boolean isDisqualified() {
            int type;
            int mispunchIndex = 0;
            int size = SIEventLoader.this.tokenList.getNumberOfTokens();
            do {
                if ((type = SIEventLoader.this.tokenList.typeAt(mispunchIndex)) != 11) continue;
                return true;
            } while (type != 3 && ++mispunchIndex < size);
            return false;
        }

        public int tokenType(String token) {
            String framedToken = "~" + token + "~";
            try {
                if (SIEventLoader.this.KmSymbols.indexOf(framedToken) != -1) {
                    return 4;
                }
                if (token.length() == 2 && SIEventLoader.this.ClimbSymbols.indexOf(framedToken) != -1) {
                    return 5;
                }
                if (SIEventLoader.this.NumControlSymbols.indexOf(framedToken) != -1) {
                    return 6;
                }
                if (token.length() == 1 && SIEventLoader.this.FinishSymbols.indexOf(framedToken) != -1) {
                    return 9;
                }
                if (token.indexOf("(") != -1) {
                    if ("0123456789".indexOf(token.substring(0, 1)) != -1) {
                        return 8;
                    }
                    if ("0123456789".indexOf(token.substring(1, 1)) != -1) {
                        return 7;
                    }
                }
                if (SIEventLoader.this.NonCompSymbols.indexOf(framedToken) != -1) {
                    return 10;
                }
                if (token.length() >= 1 && SIEventLoader.this.DsqSymbols.indexOf(framedToken) != -1) {
                    return 11;
                }
                if (token.indexOf(":") != -1 && "0123456789".indexOf(token.substring(0, 1)) != -1 || token.charAt(0) == ':' || token.indexOf("---") != -1 || token.charAt(0) == '*' || token.equals("0.00")) {
                    return 3;
                }
                if (token.indexOf(".") != -1) {
                    Float f = new Float(token);
                    if (f.floatValue() > 0.0f) {
                        return 1;
                    }
                }
                if (Integer.parseInt(token) > 0) {
                    return 2;
                }
            }
            catch (NumberFormatException e) {
                return 0;
            }
            return 0;
        }

        private Token sub(String buffer, int start) {
            int s = start;
            while (s < buffer.length() && buffer.charAt(s) == ' ') {
                ++s;
            }
            if (s == buffer.length()) {
                return new Token("", s, 0);
            }
            int e = s;
            while (e < buffer.length() && buffer.charAt(e) != ' ') {
                ++e;
            }
            start = e;
            String w = buffer.substring(s, e);
            return new Token(w, e, this.tokenType(w));
        }

        public String stringAt(int i) {
            Token t = (Token)this.tokens.elementAt(i);
            return t.value;
        }

        public int typeAt(int i) {
            Token t = (Token)this.tokens.elementAt(i);
            return t.type;
        }

        private void printTokentypes() {
            StringBuffer s = new StringBuffer("        [" + stringLT[SIEventLoader.this.tokenList.lineType()] + "]  ");
            int i = 0;
            while (i < SIEventLoader.this.tokenList.getNumberOfTokens()) {
                s.append(String.valueOf(SIEventLoader.this.tokenList.stringAt(i)) + "{" + stringTT[this.tokenType(SIEventLoader.this.tokenList.stringAt(i))] + "},  ");
                ++i;
            }
            System.out.println("  " + s);
        }

        private class Token {
            String value;
            int end;
            int type;

            public Token() {
            }

            public Token(String s, int e, int t) {
                this.value = s;
                this.end = e;
                this.type = t;
            }
        }
    }
}

