/*
 * Decompiled with CFR 0.152.
 */
public class Result {
    private String name;
    private String club;
    private int startNumber;
    private Time startTime;
    private AgeClass ageClass;
    private Course course;
    private Time[] totalTimes;
    private Time[] splitTimes = null;
    private int[] position = null;
    private int[] splitPosition = null;
    private boolean isValid = false;
    private Time sortTime;

    public Result() {
    }

    public Result(String newName, String newClub, Course newCourse, AgeClass newAgeClass, Time[] newTimes, Time newStartTime, int newStartNumber, boolean newIsValid) {
        this.name = newName;
        this.club = newClub;
        this.startNumber = newStartNumber;
        this.course = newCourse;
        this.ageClass = newAgeClass;
        this.totalTimes = newTimes;
        this.startTime = newStartTime;
        this.isValid = newIsValid;
        this.position = new int[newTimes.length];
        this.splitPosition = new int[newTimes.length];
        if (newTimes.length != newCourse.getNumControls() + 1) {
            System.out.println("Error in Results constructor: Number of controls not OK for " + newName);
        }
    }

    public Result(String newName, String newClub, Course newCourse, AgeClass newAgeClass, Time[] newTimes, Time newStartTime, boolean newIsValid) {
        this(newName, newClub, newCourse, newAgeClass, newTimes, newStartTime, -1, newIsValid);
    }

    public Result(int numControls, Course newCourse) {
        this.totalTimes = new Time[numControls + 1];
        this.position = new int[numControls + 1];
        this.splitPosition = new int[numControls + 1];
        this.course = newCourse;
    }

    public Result(Result result) {
        this.name = result.name;
        this.club = result.club;
        this.startNumber = result.startNumber;
        this.course = result.course;
        this.ageClass = result.ageClass;
        this.totalTimes = new Time[result.totalTimes.length];
        int i = result.totalTimes.length - 1;
        while (i >= 0) {
            this.totalTimes[i] = new Time(result.getTime(i));
            --i;
        }
        this.startTime = result.startTime;
        this.isValid = result.isValid;
        this.position = new int[result.totalTimes.length];
        this.splitPosition = new int[result.totalTimes.length];
        this.splitTimes = null;
    }

    public void setTime(int numControl, Time newTime) {
        this.totalTimes[numControl] = new Time(newTime.asSeconds(), newTime.isValid());
    }

    public void setTime(int numControl, int seconds, boolean isValid) {
        this.totalTimes[numControl] = new Time(seconds, isValid);
    }

    private void calcSplitTimes() {
        Time lastValidTime = new Time(0, true);
        int len = this.totalTimes.length;
        this.splitTimes = new Time[len];
        int i = 0;
        while (i < len) {
            if (this.course.isValidControl(i)) {
                this.splitTimes[i] = this.getTime(i).subtract(lastValidTime);
                this.splitTimes[i].asSeconds();
                lastValidTime = this.getTime(i);
            } else {
                this.splitTimes[i] = Time.INVALIDTIME;
            }
            ++i;
        }
    }

    public int getNumControls() {
        return this.totalTimes.length - 1;
    }

    public Time getTime(int numControl) {
        if (numControl == -1) {
            return Time.ZEROTIME;
        }
        if (this.totalTimes[numControl] == null) {
            this.addMissingTimes();
            return Time.INVALIDTIME;
        }
        return this.totalTimes[numControl];
    }

    public Time getAbsoluteTime(int numControl) {
        if (this.startTime == null) {
            return Time.INVALIDTIME;
        }
        return this.startTime.add(this.getTime(numControl));
    }

    public Time getStartTime() {
        if (this.startTime == null) {
            return Time.INVALIDTIME;
        }
        return this.startTime;
    }

    public void setStartTime(Time newStartTime) {
        this.startTime = new Time(newStartTime.asSeconds(), newStartTime.isValid());
    }

    public void setStartTimeAsSeconds(int newStartTimeAsSeconds) {
        this.startTime.setSeconds(newStartTimeAsSeconds);
    }

    public Time getFinishTime() {
        return this.getTime(this.totalTimes.length - 1);
    }

    public String getName() {
        return this.name;
    }

    public String getName(int width) {
        String s = String.valueOf(this.name) + "                                                      ";
        return s.substring(0, width);
    }

    public String getClub() {
        return this.club;
    }

    public String getClub(int width) {
        String s = String.valueOf(this.club) + "                                                      ";
        return s.substring(0, width);
    }

    public void setClub(String newClub) {
        this.club = newClub;
    }

    public Course getCourse() {
        return this.course;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean newIsValid) {
        this.isValid = newIsValid;
    }

    public Time getSplitTime(int numControl) {
        if (this.splitTimes == null) {
            this.calcSplitTimes();
        }
        if (numControl < 0 || numControl >= this.totalTimes.length) {
            System.out.println("Result.getSplitTime for " + this.name + "/" + this.ageClass.getName() + " numControl=" + numControl + "[" + (this.totalTimes.length - 1) + "]");
            return Time.ZEROTIME;
        }
        return this.splitTimes[numControl];
    }

    public Time getSplitToPreviousControl(int numControl) {
        Time prevTime = Time.ZEROTIME;
        if (numControl > 0) {
            prevTime = this.getTime(numControl - 1);
        }
        return this.getTime(numControl).subtract(prevTime);
    }

    public Time getSortTime() {
        return this.sortTime;
    }

    public void setSortTime(Time newSortTime) {
        this.sortTime = newSortTime;
    }

    public AgeClass getAgeClass() {
        return this.ageClass;
    }

    public void addMissingTimes() {
        int i = this.totalTimes.length - 1;
        while (i >= 0) {
            if (this.totalTimes[i] != null) break;
            this.totalTimes[i] = Time.INVALIDTIME;
            --i;
        }
    }

    public int getStartNumber() {
        return this.startNumber;
    }

    public int getTotalPos(int numControl) {
        return this.position[numControl];
    }

    public int getSplitPos(int numSplit) {
        return this.splitPosition[numSplit];
    }

    public void setTotalPos(int numControl, int newPosition) {
        this.position[numControl] = newPosition;
    }

    public void setSplitPos(int numControl, int newSplitPosition) {
        this.splitPosition[numControl] = newSplitPosition;
    }

    public void invalidateSplitTimes() {
        this.splitTimes = null;
    }

    public void checkForInvalidControls() {
        int i = this.totalTimes.length - 2;
        while (i >= 0) {
            Time time = this.getTime(i);
            if (time.isFailedSIBox()) {
                this.course.setControlInvalid(i);
            }
            --i;
        }
    }
}

