/*
 * Decompiled with CFR 0.152.
 */
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Message {
    private static String language = null;
    private static String country;
    private static Locale currentLocale;
    private static ResourceBundle messages;
    private static boolean useLocalArray;
    private static String[][] msgText;

    static {
        useLocalArray = false;
        msgText = new String[][]{{"Main.KeyTimeDiff", "s"}, {"Main.KeyPercentBehind", "r"}, {"Main.KeyActualTime", "a"}, {"Main.KeyPos", "p"}, {"Main.KeySplitPos", "l"}, {"Main.KeyResultsTable", "t"}, {"Main.TimeDifferenceGraph", "Graph: S)plittimes"}, {"Main.PercentBehindGraph", "Graph: peR)cent behind"}, {"Main.ActualTimeGraph", "Graph: A)bsolute time"}, {"Main.PosGraph", "Graph: P)osition after leg"}, {"Main.SplitPosGraph", "Graph: L)eg position"}, {"Main.ResultsTable", "T)able of results"}, {"Main.CrossingRunners", "Crossing runners "}, {"Main.Winner", "Winner"}, {"Main.FastestTime", "Fastest time"}, {"Main.AnyRunner", "Any runner"}, {"Main.Class", "Class"}, {"Main.View", "View"}, {"Main.CompareAgainst", "Compare with"}, {"Main.TotalTime", "Total time"}, {"Main.TotalPos", "Position"}, {"Main.SplitTime", "Splittime"}, {"Main.SplitPos", "Splitposition"}, {"Main.TimeBehind", "Time behind"}, {"Main.Runner", "Runner"}, {"Main.About", "Info"}, {"Main.Loading", "\nResults are being read from file {0} ...\n \nWhen results have been loaded you can close your your connection (analysis is off-line)."}, {"Main.LoadingShort", "\nResults are being read from file {0}"}, {"Main.FileError", "Error loading data. Applet terminated."}, {"Main.SelectAll", "All"}, {"Main.DeselectAll", "None"}, {"Main.ClickHere", "Mouse key(s) for additional information"}, {"Graph.Start", "Start"}, {"Graph.Finish", "Finish"}, {"Graph.NoStartTime", "Starttime(s) missing"}, {"Graph.Time", "Time (Min)"}, {"Graph.FastestSplit", "Fastest leg-time"}, {"Loader.Error", "Error when reading file {0} in line {1}\n\nError: "}, {"Loader.OpenError", "Error opening file {0}"}, {"SILoader.UnexpectedCourseHeader", "Unexpected course/agclass header"}, {"SILoader.WrongNoControls", "Wrong number of controls. Course {0} has {1,number,integer} controls"}, {"SILoader.MissingCourse", "Missing course/ageclass"}, {"SILoader.MissingFirstLine", "The first line (containing the name) is missing for this runner"}, {"SILoader.UnknownLine", "Unknown line format in line {0,number,integer}."}, {"SILoader.HTMLError", "Error removing HTML tags (HTML tag not closed ??)"}, {"SILoader.Error", "Error reading SI input file:"}, {"SILoader.MissingTimes", "Line {1}: Missing times {0}"}, {"SILoader.MissingTime", "In FULL results split time must be followed by time and position (Split {0})"}, {"SILoader.MissingStartNumber", "Wrong or missing startnumber in line {0}"}, {"SILoader.BadSiSymbols\t\t\t= Parameter 'siymbols' consist of 6 strings separated by ';'. Only {0,number,integer} strings found"}, {"SILoader.Eventname", "No eventheader found: Must be preceded by <td><nobr><b>. Alternatively use PARAMeter 'eventname' to specify."}, {"SILoader.StartnoByName", "No startnumbers found in results. Starttimes are matched to results by name (slower)"}, {"SILoader.StartnoByNumber", "Startnumbers found in results. Starttimes are matched to results by startnumber"}, {"SILoader.NoStartTimes", "No file with starttimes specified."}, {"SILoader.LoadingResults", "Results are loaded from file {0}"}, {"SILoader.NoData", "No data found."}, {"SILoader.LoadingStartTimes", "Starttimes are loaded from file {0}"}, {"SILoader.StartlistError", "Error when reading starttimes from: "}, {"Table.SelectOneClass", "Please choose exactly one class to view the results"}, {"Time.BadSplit", "Invalid time format -->"}, {"ControlCollection.Control", "Control"}, {"Result.SplitTime", "Error: Splittime {0} is negative. Set to 0."}};
    }

    public static void init(String newLanguage, String newCountry) {
        language = newLanguage;
        country = newCountry;
        Message.loadMessages();
    }

    private static void loadMessages() {
        try {
            currentLocale = new Locale(language, country);
            messages = ResourceBundle.getBundle("Messages", currentLocale);
            useLocalArray = false;
        }
        catch (Exception e) {
            if (language != null && country != null) {
                System.err.println("Error loading locale specific data for country='" + country + "'; language='" + language + "'. Using English instead.");
            }
            useLocalArray = true;
        }
    }

    private static String getString(String msgID) {
        boolean OK = true;
        if (language == null) {
            Message.loadMessages();
        }
        if (!useLocalArray) {
            try {
                return messages.getString(msgID);
            }
            catch (Exception e) {
                OK = false;
            }
        }
        if (useLocalArray || !OK) {
            int i = 0;
            while (i < msgText.length) {
                if (msgID.equals(msgText[i][0])) {
                    return msgText[i][1];
                }
                ++i;
            }
        }
        return "???";
    }

    public static String get(String msgID) {
        return Message.getString(msgID);
    }

    public static String get(String msgID, String arg0) {
        Object[] args = new Object[]{arg0};
        MessageFormat msgFmt = new MessageFormat(Message.getString(msgID));
        return msgFmt.format(args);
    }

    public static String get(String msgID, String arg0, int arg1) {
        Object[] args = new Object[]{arg0, new Integer(arg1)};
        MessageFormat msgFmt = new MessageFormat(Message.getString(msgID));
        return msgFmt.format(args);
    }

    public static String get(String msgID, int arg0) {
        Object[] args = new Object[]{new Integer(arg0)};
        MessageFormat msgFmt = new MessageFormat(Message.getString(msgID));
        return msgFmt.format(args);
    }

    public static String get(String msgID, Object[] args) {
        MessageFormat msgFmt = new MessageFormat(Message.getString(msgID));
        return msgFmt.format(args);
    }
}

