/*
 * Decompiled with CFR 0.152.
 */
public class Debug {
    private OEvent Event;

    public Debug(OEvent newEvent) {
        this.Event = newEvent;
    }

    public void listAgeClass(AgeClass ageClass) {
        Course course = ageClass.getCourse();
        System.out.println("    " + ageClass.getName() + "  " + ageClass.getNumResults() + " runners");
        int nR = 0;
        while (nR < ageClass.getNumResults()) {
            Result result = ageClass.getResult(nR);
            String Valid = result.isValid() ? " " : "*";
            String s = "";
            int i = 0;
            while (i <= course.getNumControls()) {
                s = result.getTime(i) == null ? String.valueOf(s) + "  null" : String.valueOf(s) + " " + result.getTime(i).toString();
                ++i;
            }
            s = String.valueOf(s) + "   [";
            s = result.getStartTime() == null ? String.valueOf(s) + "null]" : String.valueOf(s) + result.getStartTime().toString() + "]";
            System.out.println("        [" + result.getStartNumber() + "]" + Valid + " " + result.getName(30) + " " + result.getClub(20) + s);
            ++nR;
        }
    }

    public void listCourse(Course course) {
        System.out.println(String.valueOf(course.getName()) + "/" + course.getDistance() + "/" + course.getClimb() + "m/" + course.getNumControls() + " C\n" + course.getControlCodes());
        String sep = "";
        int i = 0;
        while (i < course.getNumControls()) {
            if (!course.isValidControl(i)) {
                System.out.print("*");
            }
            System.out.print(String.valueOf(sep) + course.getControlCode(i));
            sep = ",";
            ++i;
        }
        System.out.println("");
        int nA = 0;
        while (nA < course.getNumAgeClasses()) {
            AgeClass ageClass = course.getAgeClass(nA);
            this.listAgeClass(ageClass);
            ++nA;
        }
    }

    public void listAll() {
        System.out.println("---------------------------------------------------------");
        int nC = 0;
        while (nC < this.Event.getNumCourses()) {
            Course course = this.Event.getCourse(nC);
            this.listCourse(course);
            ++nC;
        }
    }
}

