/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Course {
    private String name;
    private int numControls;
    private String[] controlCodes;
    private int[] controlStatus;
    private String distance = "";
    private String climb = "";
    private Vector ageClasses = new Vector(3);
    private String strControlCodes = "";
    private static final int CONTROL_VALID = 0;
    private static final int CONTROL_INVALID_AUTO = 1;
    private static final int CONTROL_INVALID_MANUAL = 2;

    public Course() {
    }

    public Course(String newName, int newNumControls, String newDistance, String newClimb) {
        this.name = newName;
        this.numControls = newNumControls;
        this.distance = newDistance;
        this.climb = newClimb;
        this.strControlCodes = null;
        this.controlCodes = new String[newNumControls + 1];
        this.controlCodes[newNumControls] = Message.get("Graph.Finish");
        this.controlStatus = new int[newNumControls + 1];
        this.setAllControlsAsValid();
    }

    public boolean isEqual(Course compareCourse) {
        boolean eq = true;
        if (this.name != null && compareCourse.name != null) {
            boolean bl = eq = eq && this.name.equals(compareCourse.name);
        }
        if (this.numControls != 0 && compareCourse.numControls != 0) {
            boolean bl = eq = eq && this.numControls == compareCourse.numControls;
        }
        if (this.distance != null && compareCourse.distance != null) {
            boolean bl = eq = eq && this.distance.equals(compareCourse.distance);
        }
        if (this.climb != null && compareCourse.climb != null) {
            boolean bl = eq = eq && this.climb.equals(compareCourse.climb);
        }
        if (this.strControlCodes != null && compareCourse.strControlCodes != null) {
            eq = eq && this.strControlCodes.equals(compareCourse.strControlCodes);
        }
        return eq;
    }

    public String getName() {
        if (this.name == "") {
            String s = "";
            int j = 0;
            while (j < this.getNumAgeClasses()) {
                s = s == "" ? this.getAgeClass(j).getName() : String.valueOf(s) + "/" + this.getAgeClass(j).getName();
                ++j;
            }
            return s;
        }
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public int getNumControls() {
        return this.numControls;
    }

    public String getDistance() {
        if (this.distance == null) {
            return "0";
        }
        return this.distance;
    }

    public String getClimb() {
        if (this.climb == null) {
            return "0";
        }
        return this.climb;
    }

    public String getControlCodes() {
        return this.strControlCodes;
    }

    public String getControlCode(int i) {
        if (i == -1) {
            return Message.get("Graph.Start");
        }
        if (i < -1) {
            return "";
        }
        if (i > this.getNumControls()) {
            return "";
        }
        if (this.controlCodes[i] == null) {
            return "";
        }
        return this.controlCodes[i];
    }

    public boolean isValidControl(int controlNum) {
        if (controlNum < 0 || controlNum >= this.numControls) {
            return true;
        }
        return this.controlStatus[controlNum] == 0;
    }

    public void setValidControl(int controlNum, boolean newIsValid) {
        this.controlStatus[controlNum] = newIsValid ? 0 : 2;
    }

    public void setControlInvalid(int controlNum) {
        if (this.controlStatus[controlNum] != 2) {
            this.controlStatus[controlNum] = 1;
        }
    }

    public void setAllControlsAsValid() {
        int i = 0;
        while (i <= this.numControls) {
            this.controlStatus[i] = 0;
            ++i;
        }
    }

    public AgeClass addAgeClass(AgeClass newAgeClass) {
        AgeClass ageClass = this.findAgeClass(newAgeClass);
        if (ageClass == null) {
            this.ageClasses.addElement(newAgeClass);
            newAgeClass.setCourse(this);
            return newAgeClass;
        }
        return ageClass;
    }

    public AgeClass getAgeClass(int i) {
        return (AgeClass)this.ageClasses.elementAt(i);
    }

    public int getNumAgeClasses() {
        return this.ageClasses.size();
    }

    public AgeClass findAgeClass(AgeClass newAgeClass) {
        int i = this.getNumAgeClasses() - 1;
        while (i >= 0) {
            AgeClass a = this.getAgeClass(i);
            if (a.isEqual(newAgeClass)) {
                return a;
            }
            --i;
        }
        return null;
    }

    public void addControlCode(int numControl, String newCC) {
        this.controlCodes[numControl - 1] = newCC;
        this.strControlCodes = this.strControlCodes == null || this.strControlCodes.equals("") ? newCC : String.valueOf(this.strControlCodes) + "," + newCC;
    }

    public Result findResult(String name) {
        int i = this.getNumAgeClasses() - 1;
        while (i >= 0) {
            Result res = this.getAgeClass(i).findResult(name);
            if (res != null) {
                return res;
            }
            --i;
        }
        return null;
    }

    public Result findResult(int startNumber) {
        int i = this.getNumAgeClasses() - 1;
        while (i >= 0) {
            Result res = this.getAgeClass(i).findResult(startNumber);
            if (res != null) {
                return res;
            }
            --i;
        }
        return null;
    }

    public void invalidateSplitTimes() {
        int i = this.getNumAgeClasses() - 1;
        while (i >= 0) {
            AgeClass ageclass = this.getAgeClass(i);
            ageclass.invalidateSplitTimes();
            --i;
        }
    }
}

