/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class ControlCollection {
    Reference[] controls = null;
    private static final int SECONDSBEFORE = 120;
    private static final int SECONDSAFTER = 120;
    private OEvent Event;
    LessThanControl lt = new LessThanControl();
    LessThanTime ltt = new LessThanTime();
    LessThanString lts = new LessThanString();

    public ControlCollection(OEvent newEvent) {
        this.Event = newEvent;
        Vector<Reference> newControls = new Vector<Reference>(200, 40);
        int nC = 0;
        while (nC < this.Event.getNumCourses()) {
            Course course = this.Event.getCourse(nC);
            int i = -1;
            while (i <= course.getNumControls()) {
                newControls.addElement(new Reference(course, i, course.getControlCode(i)));
                ++i;
            }
            ++nC;
        }
        newControls.addElement(new Reference(null, -1, "zzz"));
        this.controls = new Reference[newControls.size()];
        int i = newControls.size() - 1;
        while (i >= 0) {
            this.controls[i] = (Reference)newControls.elementAt(i);
            --i;
        }
        Sorter.Sort(this.controls, 0, this.controls.length - 1, this.lt);
    }

    private int findFirstCourseForControl(String controlCode) {
        String control = this.padControl(controlCode);
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i].controlCode.equals(control)) {
                return i;
            }
            ++i;
        }
        return this.controls.length - 1;
    }

    private String padControl(String controlCode) {
        if (controlCode.length() >= 3) {
            return controlCode;
        }
        if (controlCode.length() >= 2) {
            return " " + controlCode;
        }
        return "  " + controlCode;
    }

    private Result[] getRunnersAtControl(String controlCode, Time timeFrom, Time timeTo) {
        Vector<Result> vRunners = new Vector<Result>(100, 20);
        int i = this.findFirstCourseForControl(this.padControl(controlCode));
        while (this.controls[i].controlCode.equals(this.padControl(controlCode))) {
            Course course = this.controls[i].course;
            int iSplit = this.controls[i].splitNo;
            int nA = 0;
            while (nA < course.getNumAgeClasses()) {
                AgeClass ageClass = course.getAgeClass(nA);
                int nR = 0;
                while (nR < ageClass.getNumResults()) {
                    Result result = ageClass.getResult(nR);
                    Time splitAbsoluteTime = result.getAbsoluteTime(iSplit);
                    if (splitAbsoluteTime.isValid() && timeFrom.lessThan(splitAbsoluteTime) && splitAbsoluteTime.lessThan(timeTo)) {
                        result.setSortTime(splitAbsoluteTime);
                        vRunners.addElement(result);
                    }
                    ++nR;
                }
                ++nA;
            }
            ++i;
        }
        if (vRunners.size() > 0) {
            Object[] runners = new Result[vRunners.size()];
            i = vRunners.size() - 1;
            while (i >= 0) {
                runners[i] = (Result)vRunners.elementAt(i);
                --i;
            }
            Sorter.Sort(runners, 0, runners.length - 1, this.ltt);
            return runners;
        }
        return new Result[0];
    }

    public String[] getTimesNear(Time timeAtControl, String controlCode, Vector ageClasses) {
        Vector vRunners = new Vector(20);
        Time timeFrom = new Time(timeAtControl.asSeconds() - 120);
        Time timeTo = new Time(timeAtControl.asSeconds() + 120);
        Result[] runners = this.getRunnersAtControl(controlCode, timeFrom, timeTo);
        String[] res = new String[runners.length + 1];
        res[0] = "[" + timeFrom.toString() + "-" + timeTo.toString() + "]  " + Message.get("ControlCollection.Control") + " (" + controlCode + ")";
        int i = 0;
        while (i < runners.length) {
            String suffix = "";
            int j = 0;
            AgeClass ac = runners[i].getAgeClass();
            while (j < ageClasses.size()) {
                if (((AgeClass)ageClasses.elementAt(j)).isEqual(ac)) {
                    suffix = "*";
                    break;
                }
                ++j;
            }
            res[i + 1] = String.valueOf(runners[i].getSortTime().toString()) + "  " + ac.getName() + " / " + runners[i].getName() + suffix;
            ++i;
        }
        return res;
    }

    public String[] getFastestTimesForLeg(String fromControlCode, String toControlCode, Vector ageClasses) {
        int iFrom = this.findFirstCourseForControl(this.padControl(fromControlCode));
        int storediTo = this.findFirstCourseForControl(this.padControl(toControlCode));
        Vector<String> v = new Vector<String>(0);
        String suffix = "";
        while (this.controls[iFrom].controlCode.equals(this.padControl(fromControlCode))) {
            Course courseFrom = this.controls[iFrom].course;
            int iTo = storediTo;
            while (this.controls[iTo].controlCode.equals(this.padControl(toControlCode))) {
                Course courseTo = this.controls[iTo].course;
                if (courseFrom.equals(courseTo) && this.controls[iFrom].splitNo + 1 == this.controls[iTo].splitNo) {
                    int i = courseFrom.getNumAgeClasses() - 1;
                    while (i >= 0) {
                        suffix = this.isInVector(ageClasses, courseFrom.getAgeClass(i)) ? "*" : "";
                        v.addElement(String.valueOf(courseFrom.getAgeClass(i).getFastestLegTime(this.controls[iTo].splitNo)) + suffix);
                        --i;
                    }
                }
                ++iTo;
            }
            ++iFrom;
        }
        Object[] s = new String[v.size() + 1];
        s[0] = String.valueOf(Message.get("Graph.FastestSplit")) + "  " + fromControlCode + " -> " + toControlCode;
        int i = v.size() - 1;
        while (i >= 0) {
            s[i + 1] = (String)v.elementAt(i);
            --i;
        }
        Sorter.Sort(s, 1, v.size(), this.lts);
        return s;
    }

    private boolean isInVector(Vector ageClasses, AgeClass ageClass) {
        int i = ageClasses.size() - 1;
        while (i >= 0) {
            if (((AgeClass)ageClasses.elementAt(i)).equals(ageClass)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public String[] getCoursesForControlNo(String controlCode) {
        int i;
        int iStart = i = this.findFirstCourseForControl(this.padControl(controlCode));
        while (this.controls[i].controlCode.equals(this.padControl(controlCode))) {
            ++i;
        }
        Object[] courses = new String[i - iStart + 1];
        int j = 1;
        i = iStart;
        courses[0] = String.valueOf(Message.get("ControlCollection.Control")) + " (" + controlCode + ")";
        while (this.controls[i].controlCode.equals(this.padControl(controlCode))) {
            String nextControl = this.controls[i].course.getControlCode(this.controls[i].splitNo + 1);
            if (!nextControl.equals("")) {
                nextControl = " --> (" + nextControl + ")";
            }
            courses[j++] = String.valueOf(this.controls[i++].course.getName()) + nextControl;
        }
        Sorter.Sort(courses, 1, courses.length - 1, this.lts);
        return courses;
    }

    public Time[] getTimesAtControl(String controlCode, Time timeFrom, Time timeTo) {
        Result[] runners = this.getRunnersAtControl(controlCode, timeFrom, timeTo);
        Time[] times = new Time[runners.length];
        int i = 0;
        while (i < runners.length) {
            times[i] = runners[i].getSortTime();
            ++i;
        }
        return times;
    }

    private class Reference {
        public Course course;
        public int splitNo;
        public String controlCode;

        public Reference() {
        }

        public Reference(Course newCourse, int newSplitNo, String newControlNo) {
            this.course = newCourse;
            this.splitNo = newSplitNo;
            this.controlCode = ControlCollection.this.padControl(newControlNo);
        }
    }

    private class LessThanControl
    implements ICompare {
        LessThanControl() {
        }

        public boolean lessThan(Object a, Object b) {
            return ((Reference)a).controlCode.compareTo(((Reference)b).controlCode) < 0;
        }
    }

    private class LessThanTime
    implements ICompare {
        LessThanTime() {
        }

        public boolean lessThan(Object a, Object b) {
            return ((Result)a).getSortTime().lessThan(((Result)b).getSortTime());
        }
    }

    private class LessThanString
    implements ICompare {
        LessThanString() {
        }

        public boolean lessThan(Object a, Object b) {
            return ((String)a).compareTo((String)b) < 0;
        }
    }
}

