/*
 * Decompiled with CFR 0.152.
 */
public class Axis {
    private double maxPixel = 0.0;
    private double minPixel = 0.0;
    private double maxTime = Time.ZEROTIME.asSeconds();
    private double minTime = Time.ZEROTIME.asSeconds();
    private transient int firstLabel;
    private transient int gridInterval;
    private transient double pixelsPerSec;
    private static int SEC_PER_MIN = 60;
    private boolean roundTimes;
    private static final int[] intervals = new int[]{1, 2, 5};
    private static final int noIntervals = 3;

    public Axis(boolean newRoundTimes) {
        this.roundTimes = newRoundTimes;
    }

    public int getMaxPixel() {
        return (int)this.maxPixel;
    }

    public void setMaxPixel(int newMaxPixel) {
        this.maxPixel = newMaxPixel;
        this.computeMapping();
    }

    public int getMinPixel() {
        return (int)this.minPixel;
    }

    public void setMinPixel(int newMinPixel) {
        this.minPixel = newMinPixel;
        this.computeMapping();
    }

    public Time getMaxTime() {
        return new Time((int)this.maxTime);
    }

    public void setMaxTime(Time newMaxTime) {
        this.maxTime = this.roundTimes ? (double)(SEC_PER_MIN * (newMaxTime.asSeconds() / SEC_PER_MIN + 1)) : (double)newMaxTime.asSeconds();
        this.computeMapping();
    }

    public Time getMinTime() {
        return new Time((int)this.minTime);
    }

    public void setMinTime(Time newMinTime) {
        if (this.roundTimes) {
            this.minTime = SEC_PER_MIN * (newMinTime.asSeconds() / SEC_PER_MIN);
            if (newMinTime.asSeconds() < 0) {
                this.minTime -= (double)SEC_PER_MIN;
            }
        } else {
            this.minTime = newMinTime.asSeconds();
        }
        this.computeMapping();
    }

    public int getNumLabels() {
        return ((int)this.maxTime - this.firstLabel) / this.gridInterval + 1;
    }

    public int getLabelPixel(int i) {
        return this.toPixel(this.firstLabel + i * this.gridInterval);
    }

    public String getLabelString(int i) {
        return new Integer((this.firstLabel + i * this.gridInterval) / SEC_PER_MIN).toString();
    }

    public void setRoundTimes(boolean newRoundPixel) {
        this.roundTimes = newRoundPixel;
        this.computeMapping();
    }

    public boolean getRoundTimes() {
        return this.roundTimes;
    }

    public Time toTime(int pixel) {
        int intTime = (int)(((double)pixel - this.minPixel) / this.pixelsPerSec + this.minTime);
        return new Time(intTime);
    }

    public int toPixel(Time time) {
        return this.toPixel(time.asSeconds());
    }

    public int toPixel(int seconds) {
        return (int)(((double)seconds - this.minTime) * this.pixelsPerSec + this.minPixel);
    }

    private void computeMapping() {
        if (this.maxTime < (double)SEC_PER_MIN) {
            this.maxTime = SEC_PER_MIN;
        }
        if (this.minTime == this.maxTime) {
            this.maxTime += (double)SEC_PER_MIN;
        }
        double timeRange = this.maxTime - this.minTime;
        this.pixelsPerSec = (this.maxPixel - this.minPixel) / timeRange;
        this.gridInterval = this.gridInt(timeRange);
        int num = ((int)this.minTime + this.gridInterval - 1) / this.gridInterval;
        this.firstLabel = (num + 0) * this.gridInterval;
    }

    private int gridInt(double range) {
        int r = (int)(range / (double)SEC_PER_MIN) / 6;
        int p = 1;
        int intervalPosn = 0;
        while (true) {
            intervalPosn = 0;
            while (intervalPosn < 3) {
                int w = intervals[intervalPosn] * p;
                if (w >= r) {
                    return w * SEC_PER_MIN;
                }
                ++intervalPosn;
            }
            p *= 10;
        }
    }
}

