/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.TextArea;

public class SplitsTable
extends TextArea {
    BorderLayout borderLayout1 = new BorderLayout();
    private Course course;
    private boolean courseInvalid = true;
    private boolean showCumulative;
    private boolean showComparison;
    private boolean showPositions;
    protected int CONTROL_REQ = 5;
    protected String CONTROL_GAP = "  ";
    protected int CONTROL_COLS = this.CONTROL_REQ + this.CONTROL_GAP.length();
    protected String NAME_PADDING = "                   ";
    protected String POS_PADDING = "     ";
    protected String TITLE_PADDING = String.valueOf(this.POS_PADDING) + this.NAME_PADDING + "       ";
    protected int TITLE_COLS = this.TITLE_PADDING.length();
    private boolean showSplits = true;

    public SplitsTable() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(403, 291));
        this.setFont(new Font("Courier", 0, 11));
        this.setBackground(Color.white);
        this.setEditable(false);
    }

    public void setCourse(Course course) {
        this.course = course;
        this.courseInvalid = true;
        this.repaint();
    }

    public void setShowSplits(boolean bl) {
        this.showSplits = bl;
        this.courseInvalid = true;
        this.repaint();
    }

    protected void drawCourse() {
        if (this.course != null) {
            this.setCols();
            this.setRows();
            this.setCourseText();
        }
    }

    public void paint(Graphics graphics) {
        if (this.courseInvalid) {
            this.drawCourse();
            this.courseInvalid = false;
        }
        super.paint(graphics);
    }

    protected void setCols() {
        int n = this.course.getNumSplits() * this.CONTROL_COLS + this.TITLE_COLS;
        this.setColumns(n);
    }

    protected int rowsPerResult() {
        int n = 3;
        if (this.isShowCumulative()) {
            ++n;
        }
        if (this.isShowComparison()) {
            ++n;
        }
        if (this.isShowPositions()) {
            ++n;
        }
        return n;
    }

    private void setRows() {
        int n = this.course.getNumResults() * this.rowsPerResult();
        this.setRows(n);
    }

    private String leftPad(String string, int n) {
        String string2 = string;
        while (n > string2.length()) {
            string2 = " " + string2;
        }
        return string2;
    }

    protected void setCourseText() {
        StringBuffer stringBuffer = new StringBuffer(this.getColumns() * this.getRows());
        StringBuffer stringBuffer2 = new StringBuffer(this.getColumns());
        int n = 0;
        while (n < this.getColumns()) {
            stringBuffer2.append(" ");
            ++n;
        }
        String string = stringBuffer2.toString();
        int n2 = 0;
        while (n2 < this.course.getNumResults()) {
            int n3;
            Result result = this.course.getResult(n2);
            String string2 = result.getFullName();
            stringBuffer.append(String.valueOf(this.leftPad(Integer.toString(n2 + 1), 3)) + "  ");
            if (string2.length() > this.NAME_PADDING.length()) {
                string2 = string2.substring(0, this.NAME_PADDING.length());
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2);
                n3 = this.NAME_PADDING.length() - string2.length();
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(" ");
                    ++n4;
                }
            }
            stringBuffer.append(" " + this.leftPad(result.getTotalTime().toString(), 6));
            n3 = 0;
            while (n3 < this.course.getNumSplits()) {
                if (result.getElaspsed(n3).getMins() < 100) {
                    stringBuffer.append(String.valueOf(this.CONTROL_GAP) + " " + result.getElaspsed(n3).toString());
                } else {
                    stringBuffer.append(String.valueOf(this.CONTROL_GAP) + result.getElaspsed(n3).toString());
                }
                ++n3;
            }
            stringBuffer.append("     \n");
            if (this.showSplits) {
                stringBuffer.append(this.TITLE_PADDING);
                n3 = 0;
                while (n3 < this.course.getNumSplits()) {
                    if (result.getSplit(n3).getMins() < 100) {
                        stringBuffer.append(String.valueOf(this.CONTROL_GAP) + " " + result.getSplit(n3).toString());
                    } else {
                        stringBuffer.append(String.valueOf(this.CONTROL_GAP) + result.getSplit(n3).toString());
                    }
                    ++n3;
                }
                stringBuffer.append("     \n");
            }
            stringBuffer.append(String.valueOf(string) + "\n");
            ++n2;
        }
        this.setText(stringBuffer.toString());
    }

    public Course getCourse() {
        return this.course;
    }

    public void setShowCumulative(boolean bl) {
        if (this.showCumulative != bl) {
            this.showCumulative = bl;
            this.setCourseText();
        }
    }

    public boolean isShowCumulative() {
        return this.showCumulative;
    }

    public void setShowComparison(boolean bl) {
        if (this.showComparison != bl) {
            this.showComparison = bl;
            this.setCourseText();
        }
    }

    public boolean isShowComparison() {
        return this.showComparison;
    }

    public void setShowPositions(boolean bl) {
        if (this.showPositions != bl) {
            this.showPositions = bl;
            this.setCourseText();
        }
    }

    public boolean isShowPositions() {
        return this.showPositions;
    }
}

