/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class SplitsGraph
extends Panel {
    public static final int GRAPH_TYPE_COMPARISON = 0;
    public static final int GRAPH_TYPE_RACE = 1;
    private Image offscreenBuffer;
    private Color color1 = new Color(216, 220, 255);
    private Color color2 = new Color(203, 245, 255);
    private Color gridColor = Color.white;
    private Course course = null;
    private Vector displayedResults = new Vector();
    private Axis xAxis = new Axis(false);
    private Axis yAxis = new Axis(false);
    private boolean computeDimensions = true;
    private int[] xPos = null;
    private int graphType = 0;
    private final int LEFT_MARGIN = 20;
    private final int RIGHT_MARGIN = 10;
    private final int TOP_MARGIN = 25;
    private final int BOTTOM_MARGIN = 30;
    private int LEFT_AXIS = 0;
    private int RIGHT_AXIS = 1;
    private Vector displayColors = new Vector();
    private int selectedSplit = -1;
    private boolean showTotalTime = false;
    private boolean showSplits = true;
    private boolean showTimeBehind = false;

    public SplitsGraph() {
        this.setFont(new Font("SansSerif", 0, 10));
        this.enableEvents(32L);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized() {
                SplitsGraph.this.invalidateDimensions();
            }
        });
    }

    public void setColor1(Color color) {
        if (this.color1 != color) {
            this.color1 = color;
            this.repaint();
        }
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor2(Color color) {
        if (this.color2 != color) {
            this.color2 = color;
            this.repaint();
        }
    }

    public Color getColor2() {
        return this.color2;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.repaint();
    }

    public void setCourse(Course course) {
        this.course = course;
        this.displayedResults.removeAllElements();
        this.displayColors.removeAllElements();
        if (course != null) {
            this.xPos = new int[this.course.getNumSplits() + 1];
        }
        this.invalidateDimensions();
    }

    public void invalidateDimensions() {
        this.computeDimensions = true;
        this.repaint();
    }

    public void setShowTotalTime(boolean bl) {
        this.showTotalTime = bl;
        this.repaint();
    }

    public void setShowSplits(boolean bl) {
        this.showSplits = bl;
        this.repaint();
    }

    public void setShowTimeBehind(boolean bl) {
        this.showTimeBehind = bl;
        this.repaint();
    }

    public Course getCourse() {
        return this.course;
    }

    public void displayResult(Result result) {
        Color[] colorArray = new Color[]{Color.blue, Color.red, Color.black, Color.green, Color.magenta, Color.pink, Color.darkGray};
        this.displayedResults.addElement(result);
        int n = result.getPosition() % colorArray.length;
        this.displayColors.addElement(new Color(colorArray[n].getRGB()));
        this.invalidateDimensions();
    }

    public void removeResult(Result result) {
        int n = this.displayedResults.indexOf(result);
        if (n != -1) {
            this.displayedResults.removeElementAt(n);
            this.displayColors.removeElementAt(n);
            this.invalidateDimensions();
        }
    }

    public boolean isDisplayed(Result result) {
        int n = this.displayedResults.indexOf(result);
        return n != -1;
    }

    public void setGraphType(int n) throws Exception {
        if (this.graphType != n) {
            this.graphType = n;
            this.computeDimensions = true;
            this.repaint();
        }
    }

    public int getGraphType() {
        return this.graphType;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.course == null) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.getParent().getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            return;
        }
        this.xAxis.setMinPixel(20 + this.getAxisWidth(graphics, this.LEFT_AXIS));
        this.xAxis.setMaxPixel(this.getSize().width - 10 - this.getAxisWidth(graphics, this.RIGHT_AXIS));
        this.yAxis.setMinPixel(25);
        this.yAxis.setMaxPixel(this.getSize().height - 30);
        if (this.computeDimensions) {
            this.computeGraphDimensions(graphics);
        }
        this.xPos[0] = this.xAxis.toPixel(0);
        int n = 0;
        while (n < this.course.getNumSplits()) {
            this.xPos[n + 1] = this.xAxis.toPixel(this.course.getCumulativeOptimumTime(n).asSeconds());
            ++n;
        }
        this.drawOffscreenImage();
        graphics.drawImage(this.offscreenBuffer, 0, 0, null);
    }

    protected void drawOffscreenImage() {
        int n;
        Dimension dimension = this.getSize();
        this.offscreenBuffer = this.createImage(dimension.width, dimension.height);
        Graphics graphics = this.offscreenBuffer.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n2 = fontMetrics.getHeight() / 2;
        this.paintBackground(graphics);
        int n3 = 0;
        while (n3 < this.displayedResults.size()) {
            int n4;
            graphics.setColor((Color)this.displayColors.elementAt(n3));
            Result result = (Result)this.displayedResults.elementAt(n3);
            int n5 = this.yAxis.toPixel(this.getYFirst(result));
            n = this.xPos[0];
            int n6 = 0;
            while (n6 < this.course.getNumSplits()) {
                Time time = this.getYTime(result, n6);
                if (time.isValid()) {
                    n4 = this.yAxis.toPixel(time.asSeconds());
                    graphics.drawLine(n, n5, this.xPos[n6 + 1], n4);
                    graphics.drawLine(n, n5 + 1, this.xPos[n6 + 1], n4 + 1);
                    graphics.drawLine(n + 1, n5, this.xPos[n6 + 1] + 1, n4);
                    n5 = n4;
                    n = this.xPos[n6 + 1];
                }
                ++n6;
            }
            graphics.setColor(this.getForeground());
            n6 = this.xAxis.getMaxPixel();
            n4 = this.course.getNumSplits() - 1;
            int n7 = this.yAxis.toPixel(this.getYSecs(result, n4)) + n2;
            graphics.drawString(this.getRightText(result), n6, n7);
            if (this.graphType == 1) {
                n7 = this.yAxis.toPixel(this.getYFirst(result));
                graphics.drawString(this.getLeftText(result), 20, n7);
            }
            ++n3;
        }
        graphics.setColor(this.gridColor);
        graphics.draw3DRect(this.xAxis.getMinPixel(), this.yAxis.getMinPixel(), this.xAxis.getMaxPixel() - this.xAxis.getMinPixel(), this.yAxis.getMaxPixel() - this.yAxis.getMinPixel(), false);
        graphics.setColor(this.getForeground());
        n3 = this.yAxis.getMinPixel() - 5;
        int n8 = 0;
        while (n8 < this.course.getNumControls() - 1) {
            graphics.drawString(new Integer(n8 + 1).toString(), this.xPos[n8 + 1], n3);
            ++n8;
        }
        n8 = this.course.getNumControls() - 1;
        String string = String.valueOf(new Integer(n8 + 1).toString()) + Messages.getString("SplitsGraph._control_2");
        graphics.drawString(string, this.xPos[n8 + 1], n3);
        n3 = this.yAxis.getMaxPixel() + fontMetrics.getHeight();
        n8 = 0;
        while (n8 < this.xAxis.getNumLabels() - 1) {
            graphics.drawString(this.xAxis.getLabelString(n8), this.xAxis.getLabelPixel(n8), n3);
            ++n8;
        }
        n8 = this.xAxis.getNumLabels() - 1;
        graphics.drawString(String.valueOf(this.xAxis.getLabelString(n8)) + Messages.getString("SplitsGraph._time_(mins)_3"), this.xAxis.getLabelPixel(n8), n3);
        n = this.xAxis.getMinPixel() - fontMetrics.stringWidth("88");
        n8 = 0;
        while (n8 < this.yAxis.getNumLabels()) {
            graphics.drawString(this.yAxis.getLabelString(n8), n, this.yAxis.getLabelPixel(n8) + n2);
            ++n8;
        }
    }

    protected void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(1, 1, dimension.width - 2, dimension.height - 2, false);
        boolean bl = true;
        int n = 1;
        while (n < this.course.getNumSplits() + 1) {
            if (bl) {
                graphics.setColor(this.color1);
            } else {
                graphics.setColor(this.color2);
            }
            graphics.fillRect(this.xPos[n - 1], this.yAxis.getMinPixel(), this.xPos[n] - this.xPos[n - 1], this.yAxis.getMaxPixel() - this.yAxis.getMinPixel());
            bl = !bl;
            ++n;
        }
        graphics.setColor(this.gridColor);
        n = this.xAxis.getMinPixel();
        int n2 = this.xAxis.getMaxPixel();
        int n3 = 0;
        while (n3 < this.yAxis.getNumLabels()) {
            graphics.drawLine(n, this.yAxis.getLabelPixel(n3), n2, this.yAxis.getLabelPixel(n3));
            ++n3;
        }
        if (this.selectedSplit != -1 && (this.showSplits || this.showTimeBehind)) {
            n3 = 3;
            graphics.setColor(this.gridColor);
            graphics.fillRect(this.xPos[this.selectedSplit + 1] - n3, this.yAxis.getMinPixel(), n3, this.yAxis.getMaxPixel() - this.yAxis.getMinPixel());
        }
    }

    protected int getYFirst(Result result) {
        return 0;
    }

    protected Time getYTime(Result result, int n) {
        boolean bl = result.getElaspsed(n).isValid() && this.course.getCumulativeOptimumTime(n).isValid();
        int n2 = result.getElaspsed(n).asSeconds() - this.course.getCumulativeOptimumTime(n).asSeconds();
        return new Time(n2, bl);
    }

    protected int getYSecs(Result result, int n) {
        return this.getYTime(result, n).asSeconds();
    }

    protected String getRightText(Result result) {
        StringBuffer stringBuffer = new StringBuffer("   " + result.getFullName());
        if (this.showTotalTime) {
            stringBuffer.append("  " + result.getTotalTime().toString());
        }
        if (this.selectedSplit != -1) {
            if (this.showSplits) {
                stringBuffer.append("   " + result.getSplit(this.selectedSplit).toString());
            }
            if (this.showTimeBehind) {
                stringBuffer.append("  " + result.getTimeBehindOptimum(this.selectedSplit).toStringSigned());
            }
        }
        return stringBuffer.toString();
    }

    protected String getLeftText(Result result) {
        return "";
    }

    protected void computeGraphDimensions(Graphics graphics) {
        int n;
        int n2;
        if (this.displayedResults.size() == 0) {
            n2 = 0;
            n = 1;
        } else {
            n = Integer.MIN_VALUE;
            n2 = Integer.MAX_VALUE;
            int n3 = 0;
            while (n3 < this.displayedResults.size()) {
                Result result = (Result)this.displayedResults.elementAt(n3);
                int n4 = this.getYFirst(result);
                n = Math.max(n, n4);
                n2 = Math.min(n2, n4);
                int n5 = 0;
                while (n5 < this.course.getNumSplits()) {
                    n4 = this.getYSecs(result, n5);
                    n = Math.max(n, n4);
                    n2 = Math.min(n2, n4);
                    ++n5;
                }
                ++n3;
            }
        }
        this.yAxis.setMaxTime(new Time(n));
        this.yAxis.setMinTime(new Time(n2));
        this.xAxis.setMinTime(Time.ZERO_TIME);
        this.xAxis.setMaxTime(this.course.getCumulativeOptimumTime(this.course.getNumSplits() - 1));
        this.computeDimensions = false;
    }

    protected int getAxisWidth(Graphics graphics, int n) {
        int n2 = 300;
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        Enumeration enumeration = this.displayedResults.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Result result = (Result)enumeration.nextElement();
            String string = n == this.LEFT_AXIS ? this.getLeftText(result) : this.getRightText(result);
            n3 = Math.max(n3, fontMetrics.stringWidth(string));
        }
        return Math.min(n3, n2);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.course != null) {
            int n = mouseEvent.getX();
            int n2 = 1;
            while (n2 < this.course.getNumSplits() + 1) {
                if (n > this.xPos[n2 - 1] && n <= this.xPos[n2]) {
                    if (n2 - 1 == this.selectedSplit) break;
                    this.selectedSplit = n2 - 1;
                    this.repaint();
                    break;
                }
                ++n2;
            }
        }
    }
}

