/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;

public class SplitsBrowser
extends Applet
implements Runnable {
    public static final int SI_HTML_INPUT_FORMAT = 1;
    public static final int ABM_HTML_INPUT_FORMAT = 2;
    protected Insets insets = new Insets(7, 7, 7, 7);
    EventLoader loader = null;
    Panel topPanel = new Panel();
    Panel mainPanel = new Panel();
    FlowLayout topPanelLayout = new FlowLayout();
    Label classLabel = new Label();
    Choice classChoice = new Choice();
    Label viewLabel = new Label();
    Choice viewChoice = new Choice();
    CardLayout mainPanelCardLayout = new CardLayout();
    Panel graphPanel = new Panel();
    Panel textPanel = new Panel();
    Label compareAgainstLabel = new Label();
    BorderLayout borderLayout1 = new BorderLayout();
    List resultsList = new List(1, true);
    BorderLayout borderLayout2 = new BorderLayout();
    Choice compareAgainstChoice = new Choice();
    SplitsGraph splitsGraph = new SplitsGraph();
    SplitsTable splitsTable = new SplitsTable();
    BorderLayout borderLayout3 = new BorderLayout();
    Panel bottomPanel = new Panel();
    Checkbox splitTimeChk = new Checkbox();
    Checkbox timeBehindChk = new Checkbox(Messages.getString("SplitsBrowser.Time_behind_53"), false);
    Checkbox totalTimeChk = new Checkbox();
    Panel msgPanel = new Panel();
    boolean isStandalone = false;
    private int lastIndex = -1;
    protected OEvent event = null;
    protected Course currentCourse = null;
    private String name;
    private String color1;
    private String color2;
    private String backgroundColor;
    private String courseData;
    private Thread runner = null;
    private int inputFormat;
    private String inputFilename;
    private static String VIEW_DIFFERENCE_GRAPH = Messages.getString("SplitsBrowser.Time_difference_graph_54");
    private static String VIEW_TABLE = Messages.getString("SplitsBrowser.Results_table_55");
    private static String VIEW_ACTUAL_TIME = Messages.getString("SplitsBrowser.Actual_time_graph_56");
    private Color backGroundColor = Color.gray;
    TextArea msgTextArea = new TextArea("", 10, 10, 3);
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    Panel bottomWestPanel = new Panel();
    Panel bottomPanelEast = new Panel();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    Label versionLabel = new Label();

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.showError(exception, Messages.getString("SplitsBrowser.Error_initialising_application_1"));
        }
        try {
            this.splitsGraph.setColor1(this.getColorParameter("color1", this.splitsGraph.getColor1()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.splitsGraph.setColor2(this.getColorParameter("color2", this.splitsGraph.getColor2()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Color color = this.getColorParameter("background", this.splitsGraph.getBackground());
            this.setBackground(color);
            this.topPanel.setBackground(color);
            this.classLabel.setBackground(color);
            this.compareAgainstLabel.setBackground(color);
            this.viewLabel.setBackground(color);
            this.graphPanel.setBackground(color);
            this.textPanel.setBackground(color);
            this.msgPanel.setBackground(color);
            this.msgTextArea.setBackground(color);
            this.bottomPanel.setBackground(color);
            this.splitTimeChk.setBackground(color);
            this.timeBehindChk.setBackground(color);
            this.totalTimeChk.setBackground(color);
            this.versionLabel.setBackground(color);
            this.versionLabel.setText("Splitsbrowser v" + About.VERSION);
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.splitsGraph.setBackground(this.getColorParameter("graphbackground", this.splitsGraph.getColor2()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.inputFormat = Integer.parseInt(this.getParameter("dataformat", "0"));
            System.out.println(String.valueOf(Messages.getString("SplitsBrowser.input_format_9")) + Integer.toString(this.inputFormat) + "\n");
        }
        catch (Exception exception) {
            this.showError(exception, Messages.getString("SplitsBrowser.Error_reading_data_format_parameter.__n_An_integer_value_must_be_specified_11"));
        }
        try {
            this.inputFilename = this.getParameter(Messages.getString("SplitsBrowser.inputdata_12"), Messages.getString("SplitsBrowser.No_Course_data_13"));
        }
        catch (Exception exception) {
            this.showError(exception, Messages.getString("SplitsBrowser.Error_reading_zipped_parameter_14"));
        }
    }

    public void run() {
        Thread.yield();
        this.showMessage(String.valueOf(Messages.getString("SplitsBrowser._n__Loading_event_data_from_file__15")) + this.inputFilename + "...\n");
        try {
            this.loadEvent(this.inputFilename, this.inputFormat);
            this.setEventTimeAlgorithm(OptimumTimeAlgorithms.fastest);
            this.compareAgainstChoice.select(Messages.getString("SplitsBrowser.Fastest_time_17"));
            this.hideMessage();
        }
        catch (Exception exception) {
            this.getAppletContext().showStatus(Messages.getString("SplitsBrowser.Error_reading_input_file_18"));
            this.showError(exception, Messages.getString("SplitsBrowser.Error_reading_input_file_19"));
        }
        this.graphPanel.validate();
    }

    public void loadEvent(String string, int n) throws IOException, Exception {
        OEvent oEvent = null;
        oEvent = new OEvent("");
        if (n == 1) {
            System.out.println(Messages.getString("SplitsBrowser.Creating_SI_event_loader_21"));
            this.loader = new SIEventLoader(oEvent);
        } else if (n == 2) {
            System.out.println(Messages.getString("SplitsBrowser.Creating_ABM_event_loader_22"));
            this.loader = new ABMEventLoader(oEvent);
        } else {
            System.out.println(Messages.getString("SplitsBrowser.Creating_CSV_event_loader_23"));
            this.loader = new EventLoader(oEvent);
        }
        if (this.isStandalone) {
            this.loader.loadEvent(null, string, false);
        } else {
            this.loader.loadEvent(this.getDocumentBase(), string, true);
        }
        Course course = oEvent.getCourse(0);
        this.setEvent(oEvent);
        this.splitsGraph.setCourse(course);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validate();
    }

    public void setEvent(OEvent oEvent) {
        this.event = oEvent;
        this.classChoice.removeAll();
        this.resultsList.removeAll();
        int n = Integer.MIN_VALUE;
        FontMetrics fontMetrics = this.classChoice.getFontMetrics(this.classChoice.getFont());
        int n2 = 0;
        while (n2 < this.event.getNumCourses()) {
            String string = this.event.getCourse(n2).getName();
            this.classChoice.add(string);
            n = Math.max(n, fontMetrics.stringWidth(string));
            ++n2;
        }
        n2 = 25;
        this.classChoice.setSize(n + n2, 0);
        this.topPanel.invalidate();
        this.splitsGraph.setCourse(null);
        this.splitsTable.setCourse(null);
        this.classChoice.select(0);
        this.classChoice_itemStateChanged(null);
    }

    public void setCourse(Course course) {
        this.classChoice.select(course.getName());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.topPanel.setLayout(this.topPanelLayout);
        this.setFont(new Font("Dialog", 0, 11));
        this.setSize(new Dimension(472, 478));
        this.topPanelLayout.setHgap(3);
        this.topPanelLayout.setAlignment(0);
        this.topPanelLayout.setVgap(6);
        this.mainPanel.setLayout(this.mainPanelCardLayout);
        this.classLabel.setAlignment(1);
        this.classLabel.setText(Messages.getString("SplitsBrowser.Class_25"));
        this.classChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SplitsBrowser.this.classChoice_itemStateChanged(itemEvent);
            }
        });
        this.viewLabel.setAlignment(1);
        this.viewLabel.setText(Messages.getString("SplitsBrowser._View_26"));
        this.viewChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SplitsBrowser.this.viewChoice_itemStateChanged(itemEvent);
            }
        });
        this.graphPanel.setLayout(this.borderLayout2);
        this.compareAgainstLabel.setAlignment(1);
        this.compareAgainstLabel.setText(Messages.getString("SplitsBrowser.Compare_against_27"));
        this.borderLayout1.setVgap(3);
        this.borderLayout2.setHgap(6);
        this.splitsGraph.setLayout(this.borderLayout3);
        this.resultsList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SplitsBrowser.this.resultsList_actionPerformed(actionEvent);
            }
        });
        this.resultsList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SplitsBrowser.this.resultsList_itemStateChanged(itemEvent);
            }
        });
        this.compareAgainstChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SplitsBrowser.this.compareAgainstChoice_itemStateChanged(itemEvent);
            }
        });
        this.splitsTable.setBackground(Color.white);
        this.borderLayout3.setVgap(5);
        this.borderLayout3.setHgap(5);
        this.bottomPanel.setLayout(this.borderLayout6);
        this.timeBehindChk.setState(false);
        this.timeBehindChk.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SplitsBrowser.this.timeBehindChk_itemStateChanged(itemEvent);
            }
        });
        this.totalTimeChk.setState(false);
        this.totalTimeChk.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SplitsBrowser.this.totalTimeChk_itemStateChanged(itemEvent);
            }
        });
        this.splitTimeChk.setState(true);
        this.splitTimeChk.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SplitsBrowser.this.splitTimeChk_itemStateChanged(itemEvent);
            }
        });
        this.splitTimeChk.setLabel(Messages.getString("SplitsBrowser.Split_times_28"));
        this.timeBehindChk.setLabel(Messages.getString("SplitsBrowser.Time_behind_29"));
        this.totalTimeChk.setLabel(Messages.getString("SplitsBrowser.Total_time_30"));
        this.msgPanel.setLayout(this.borderLayout4);
        this.msgTextArea.setBackground(Color.lightGray);
        this.msgTextArea.setFont(new Font("SansSerif", 0, 12));
        this.msgTextArea.setRows(100);
        this.msgTextArea.setText("textArea1");
        this.textPanel.setLayout(this.borderLayout5);
        this.textPanel.setBackground(Color.white);
        this.topPanel.setVisible(false);
        this.bottomPanelEast.setLayout(this.flowLayout1);
        this.bottomWestPanel.setLayout(this.flowLayout2);
        this.versionLabel.setText(" Splitsbrowser");
        this.add((Component)this.topPanel, "North");
        this.viewChoice.add(VIEW_DIFFERENCE_GRAPH);
        this.viewChoice.add(VIEW_TABLE);
        this.compareAgainstChoice.add(Messages.getString("SplitsBrowser.Winner_34"));
        this.compareAgainstChoice.add(Messages.getString("SplitsBrowser.Fastest_time_35"));
        this.compareAgainstChoice.add(Messages.getString("SplitsBrowser.Fastest_time_+_5%_36"));
        this.compareAgainstChoice.add(Messages.getString("SplitsBrowser.Fastest_time_+_25%_37"));
        this.compareAgainstChoice.add(Messages.getString("SplitsBrowser.Fastest_time_+_50%_38"));
        this.compareAgainstChoice.add(Messages.getString("SplitsBrowser.Fastest_time_+_75%_39"));
        this.compareAgainstChoice.add(Messages.getString("SplitsBrowser.Fastest_time_+_100%_40"));
        this.topPanel.add((Component)this.classLabel, null);
        this.topPanel.add((Component)this.classChoice, null);
        this.topPanel.add((Component)this.viewLabel, null);
        this.topPanel.add((Component)this.viewChoice, null);
        this.topPanel.add((Component)this.compareAgainstLabel, null);
        this.topPanel.add((Component)this.compareAgainstChoice, null);
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.msgPanel, "msgPanel");
        this.msgPanel.add((Component)this.msgTextArea, "Center");
        this.mainPanel.add((Component)this.graphPanel, "graphPanel");
        this.graphPanel.add((Component)this.resultsList, "West");
        this.graphPanel.add((Component)this.splitsGraph, "Center");
        this.mainPanel.add((Component)this.textPanel, "textPanel");
        this.textPanel.add((Component)this.splitsTable, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.add((Component)this.bottomWestPanel, "Center");
        this.bottomPanel.add((Component)this.bottomPanelEast, "East");
        this.bottomPanelEast.add((Component)this.totalTimeChk, null);
        this.bottomPanelEast.add((Component)this.splitTimeChk, null);
        this.bottomPanelEast.add((Component)this.timeBehindChk, null);
        this.bottomPanel.add((Component)this.versionLabel, "West");
    }

    public void start() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        } else if (this.runner.isAlive()) {
            this.runner.resume();
        }
    }

    public void stop() {
        if (this.runner != null && this.runner.isAlive()) {
            this.runner.suspend();
        }
    }

    public void destroy() {
        Thread.yield();
    }

    public String getAppletInfo() {
        return "SplitsBrowser";
    }

    void viewChoice_itemStateChanged(ItemEvent itemEvent) {
        this.updateViewShown();
    }

    private void updateViewShown() {
        String string = this.viewChoice.getSelectedItem();
        try {
            if (string == VIEW_DIFFERENCE_GRAPH) {
                this.mainPanelCardLayout.show(this.mainPanel, "graphPanel");
                this.splitsGraph.setGraphType(0);
            } else if (string == VIEW_ACTUAL_TIME) {
                this.mainPanelCardLayout.show(this.mainPanel, "graphPanel");
                this.splitsGraph.setGraphType(1);
            } else if (string == VIEW_TABLE) {
                this.mainPanelCardLayout.show(this.mainPanel, "textPanel");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void compareAgainstChoice_itemStateChanged(ItemEvent itemEvent) {
        switch (this.compareAgainstChoice.getSelectedIndex()) {
            case -1: {
                break;
            }
            case 0: {
                this.setEventTimeAlgorithm(OptimumTimeAlgorithms.winner);
                break;
            }
            case 1: {
                this.setEventTimeAlgorithm(OptimumTimeAlgorithms.fastest);
                break;
            }
            case 2: {
                OptimumTimeAlgorithms.percentBehind.setPercentBehind(5);
                this.setEventTimeAlgorithm(OptimumTimeAlgorithms.percentBehind);
                break;
            }
            case 3: {
                OptimumTimeAlgorithms.percentBehind.setPercentBehind(25);
                this.setEventTimeAlgorithm(OptimumTimeAlgorithms.percentBehind);
                break;
            }
            case 4: {
                OptimumTimeAlgorithms.percentBehind.setPercentBehind(50);
                this.setEventTimeAlgorithm(OptimumTimeAlgorithms.percentBehind);
                break;
            }
            case 5: {
                OptimumTimeAlgorithms.percentBehind.setPercentBehind(75);
                this.setEventTimeAlgorithm(OptimumTimeAlgorithms.percentBehind);
                break;
            }
            case 6: {
                OptimumTimeAlgorithms.percentBehind.setPercentBehind(100);
                this.setEventTimeAlgorithm(OptimumTimeAlgorithms.percentBehind);
                break;
            }
        }
        this.splitsGraph.invalidateDimensions();
        this.splitsTable.setCourse(this.currentCourse);
    }

    void classChoice_itemStateChanged(ItemEvent itemEvent) {
        if (this.classChoice.getSelectedIndex() == -1) {
            return;
        }
        this.currentCourse = this.event.getCourse(this.classChoice.getSelectedIndex());
        this.splitsGraph.setCourse(this.currentCourse);
        this.splitsTable.setCourse(this.currentCourse);
        this.resultsList.setVisible(false);
        this.resultsList.removeAll();
        int n = 0;
        while (n < this.currentCourse.getNumResults()) {
            this.resultsList.add(this.currentCourse.getResult(n).getFullName());
            ++n;
        }
        this.resultsList.setVisible(true);
    }

    void resultsList_itemStateChanged(ItemEvent itemEvent) {
        Integer n = (Integer)itemEvent.getItem();
        this.lastIndex = n;
        if (n != -1) {
            Result result = this.currentCourse.getResult(n);
            if (itemEvent.getStateChange() == 1) {
                this.splitsGraph.displayResult(result);
            } else {
                this.splitsGraph.removeResult(result);
            }
        }
    }

    public Insets insets() {
        return this.insets;
    }

    void resultsList_actionPerformed(ActionEvent actionEvent) {
        Result result = this.currentCourse.getResult(this.lastIndex);
        if (this.splitsGraph.isDisplayed(result)) {
            this.resultsList.select(this.lastIndex);
        } else {
            this.resultsList.deselect(this.lastIndex);
        }
    }

    void splitTimeChk_itemStateChanged(ItemEvent itemEvent) {
        this.splitsGraph.setShowSplits(itemEvent.getStateChange() == 1);
        this.splitsTable.setShowSplits(itemEvent.getStateChange() == 1);
    }

    void timeBehindChk_itemStateChanged(ItemEvent itemEvent) {
        this.splitsGraph.setShowTimeBehind(itemEvent.getStateChange() == 1);
    }

    void totalTimeChk_itemStateChanged(ItemEvent itemEvent) {
        this.splitsGraph.setShowTotalTime(itemEvent.getStateChange() == 1);
    }

    private String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    private void showError(Exception exception, String string) {
        this.showMessage(String.valueOf(string) + "\n" + exception.toString());
        exception.printStackTrace();
    }

    private void showMessage(String string) {
        this.topPanel.setVisible(false);
        this.mainPanelCardLayout.show(this.mainPanel, "msgPanel");
        this.msgTextArea.setText(string);
        this.validate();
    }

    private void hideMessage() {
        this.topPanel.setVisible(true);
        this.updateViewShown();
        this.validate();
    }

    private Color getColorParameter(String string, Color color) {
        String string2 = this.getParameter(string, "").trim();
        if (string2.length() == 0) {
            return color;
        }
        int n = 0;
        if (string2.startsWith("#")) {
            n = 1;
        }
        Integer n2 = new Integer(0);
        String string3 = "0x" + string2.substring(n, n + 2);
        n2 = Integer.decode(string3);
        Integer n3 = new Integer(0);
        n3 = Integer.decode("0x" + string2.substring(n + 2, n + 4));
        Integer n4 = new Integer(0);
        n4 = Integer.decode("0x" + string2.substring(n + 4, n + 6));
        return new Color(n2, n3, n4);
    }

    private void setEventTimeAlgorithm(OptimumTimeAlgorithms.IOptimumTimeAlgorithm iOptimumTimeAlgorithm) {
        int n = 0;
        while (n < this.event.getNumCourses()) {
            this.event.getCourse(n).setOptimumTimeAlgorithm(iOptimumTimeAlgorithm);
            ++n;
        }
    }
}

