/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public class SIEventLoader
extends EventLoader {
    protected static final String FINISH_SYMBOLS = "A<F<Z<M";
    protected static final String NUM_CONTROLS_SYMBOLS = "C<P";
    protected static final String DSQ_SYMBOLS = "pm<mp<dnf<Felst.<Fehlst<Aufg<Zeit\u00dcb";
    protected static final String NON_COMP_SYMBOLS = "nc<aK<NC";
    protected static final String KM_SYMBOLS = "km<m";
    protected static final String CLIMB_SYMBOLS = "Cm<Hm";
    protected static final int UNKNOWN = 0;
    protected static final int COURSE_HEADER = 1;
    protected static final int COURSE_INFO = 2;
    protected static final int COMP_FIRST = 3;
    protected static final int NON_COMP_FIRST = 4;
    protected static final int DSQ_FIRST = 5;
    protected static final int COMP_SECOND = 6;
    protected static final int COMP_SUBSQ = 7;
    protected static final int STRING = 0;
    protected static final int FLOAT = 1;
    protected static final int INTEGER = 2;
    protected static final int TIME = 3;
    protected static final int KM = 4;
    protected static final int CLIMB = 5;
    protected static final int NUM_CONTROLS = 6;
    protected static final int NUM_COMPETITORS = 7;
    protected static final int CONTROL_CODE = 8;
    protected static final int FINISH = 9;
    protected static final int NON_COMP = 10;
    protected static final int MISPUNCH = 11;
    protected static final int INITIAL = 100;
    protected static final int INFOF = 101;
    protected static final int INFOC = 102;
    protected static final int COMPTF = 103;
    protected static final int COMPSF = 104;
    protected static final int COMPTS = 105;
    protected static final int COMPSS = 106;
    protected static final int IGNORE = 107;
    protected static final String[] specialChars = new String[]{"&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;", "&quot;", "&amp;", "&lt;", "&gt;", "&OElig;", "&oelig;", "&Scaron;", "&scaron;", "&Yuml;", "&circ;", "&tilde;", "&ensp;", "&emsp;", "&thinsp;", "&zwnj;", "&zwj;", "&lrm;", "&rlm;", "&ndash;", "&mdash;", "&lsquo;", "&rsquo;", "&sbquo;", "&ldquo;", "&rdquo;", "&bdquo;", "&dagger;", "&Dagger;", "&permil;", "&lsaquo;", "&rsaquo;", "&euro;"};
    protected static final char[] translatedChar = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff', '\"', '&', '<', '>', '\u0152', '\u0153', '\u0160', '\u0161', '\u0178', '\u02c6', '\u02dc', '\u2002', '\u2003', '\u2009', '\u200c', '\u200d', '\u200e', '\u200f', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2030', '\u2039', '\u203a', '\u20ac'};
    protected int line = 0;
    protected String st = "";
    protected String name = "";
    protected String firstName = "";
    protected String surname = "";
    protected String club = "";
    protected Vector tokens;
    protected Vector refTokens;
    protected int refSkip = 0;
    Vector splits = new Vector(0, 1);
    protected BufferedReader reader;
    protected int numControls;
    protected int state = 100;
    protected Course course;
    protected int splitNum;
    protected int refNum;
    protected Time startTime = new Time(0, 0);

    public SIEventLoader(OEvent oEvent) {
        super(oEvent);
    }

    public void loadEvent(URL uRL, String string, boolean bl) throws IOException, Exception {
        this.numControls = 0;
        this.course = new Course(this.event);
        this.reader = this.openReader(uRL, string, bl);
        this.line = 0;
        try {
            this.st = this.getLine(this.reader);
            if (this.st == null) {
                this.formatError(Messages.getString("SIEventLoader.No_data_140"));
            }
            while (this.st.trim() != null) {
                if (this.st == null) {
                    return;
                }
                this.tokens = this.splitTokens(this.st);
                int n = this.lineType(this.tokens);
                switch (n) {
                    case 1: {
                        this.courseHeader();
                        break;
                    }
                    case 2: {
                        this.courseInfo();
                        break;
                    }
                    case 3: {
                        this.compFirst();
                        break;
                    }
                    case 4: {
                        this.state = 107;
                        break;
                    }
                    case 5: {
                        this.state = 107;
                        break;
                    }
                    case 6: {
                        this.compSecond();
                        break;
                    }
                    case 7: {
                        this.compMultipleLines();
                        break;
                    }
                    case 0: {
                        this.unknownLine();
                    }
                }
                this.st = this.getLine(this.reader);
                if (this.st != null) continue;
                return;
            }
        }
        catch (Exception exception) {
            throw new IOException(String.valueOf(Messages.getString("SIEventLoader.Error_reading_SportIdent_HTML_file_around_line___141")) + new Integer(this.line).toString() + Messages.getString("SIEventLoader._n_in_Load_Event__n_142") + Messages.getString("SIEventLoader.Data___143") + this.st + Messages.getString("SIEventLoader._n_n_Error___144") + exception.toString());
        }
    }

    protected void courseHeader() throws IOException {
        if (this.state == 103 || this.state == 100 || this.state == 107) {
            int n = 0;
            this.name = "";
            while (this.typeAt(this.tokens, n) != 1 && this.typeAt(this.tokens, n) != 7 && n < this.tokens.size()) {
                this.name = this.name.concat(" ").concat(this.stringAt(this.tokens, n++)).trim();
            }
            this.name = SIEventLoader.translateChars(this.name);
            this.numControls = 0;
            this.state = 101;
        } else {
            this.formatError("Course Header");
        }
    }

    protected void courseInfo() throws IOException, Exception {
        if (this.state == 101 || this.state == 102) {
            int n;
            if (this.state == 101) {
                this.refTokens = this.tokens;
            }
            this.state = this.typeAt(this.tokens, (n = this.tokens.size()) - 1) == 9 ? 103 : 102;
            this.numControls += n;
            if (this.state == 103) {
                --this.numControls;
                this.course = new Course(this.event, this.name, this.numControls);
            }
        } else if (this.state != 107) {
            this.formatError("Course Info");
        }
    }

    protected void compFirst() throws IOException {
        if (this.state == 103 || this.state == 107) {
            int n = this.tokens.size() - 1;
            while (this.typeAt(this.tokens, n) == 3) {
                --n;
            }
            int cfr_ignored_0 = n - 3;
            int n2 = 0;
            while (this.typeAt(this.tokens, n2) == 2 || this.typeAt(this.tokens, n2) == 10) {
                ++n2;
            }
            this.firstName = this.stringAt(this.tokens, n2);
            this.surname = "";
            int n3 = n2 + 1;
            while (n3 <= n) {
                this.surname = this.surname.concat(" ").concat(this.stringAt(this.tokens, n3)).trim();
                ++n3;
            }
            this.firstName = SIEventLoader.translateChars(this.firstName);
            this.surname = SIEventLoader.translateChars(this.surname);
            this.splitNum = 0;
            this.refNum = 0;
            this.state = 104;
        } else {
            this.formatError("Comp First");
        }
    }

    protected void compSecond() throws Exception {
        if (this.state == 104) {
            String string = "";
            int n = 0;
            int n2 = this.tokens.size();
            do {
                string = string.concat(this.stringAt(this.tokens, n));
            } while (++n < n2 && this.typeAt(this.tokens, n) != 3);
            this.club = string;
            this.club = SIEventLoader.translateChars(this.club);
            this.addSplits(n--, n2, this.refTokens.size() - this.refSkip);
            if (this.splitNum <= this.numControls) {
                this.state = 105;
            } else {
                n2 = this.splits.size();
                Time[] timeArray = new Time[n2];
                int n3 = 0;
                while (n3 <= n2 - 1) {
                    timeArray[n3] = (Time)this.splits.elementAt(n3);
                    ++n3;
                }
                this.splits.removeAllElements();
                new Result(this.firstName, this.surname, this.club, this.course, this.startTime, timeArray);
                this.state = 103;
            }
        } else if (this.state != 100 && this.state != 107 && this.state != 103) {
            this.formatError("Comp Second");
        }
    }

    protected void compMultipleLines() throws Exception {
        int n = this.refTokens.size() - this.refSkip;
        int n2 = this.tokens.size();
        if (this.state == 105) {
            this.state = 106;
        } else if (this.state == 106) {
            int n3 = this.splitNum + n < this.numControls ? n : this.numControls - this.splitNum + 1;
            this.addSplits(0, n2, n3);
            if (this.splitNum < this.numControls) {
                this.state = 105;
            } else {
                int n4 = this.splits.size();
                Time[] timeArray = new Time[n4];
                int n5 = 0;
                while (n5 <= n4 - 1) {
                    timeArray[n5] = (Time)this.splits.elementAt(n5);
                    ++n5;
                }
                this.splits.removeAllElements();
                new Result(this.firstName, this.surname, this.club, this.course, this.startTime, timeArray);
                this.state = 103;
            }
        }
    }

    protected void unknownLine() throws IOException {
        if (this.state != 100) {
            this.formatError("Unknown line");
        }
    }

    protected void addSplits(int n, int n2, int n3) throws Exception {
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            if (this.typeAt(this.tokens, n5) == 3 && this.splitNum <= this.numControls) {
                while (this.colAt(this.refTokens, n4 + this.refSkip) < this.colAt(this.tokens, n5)) {
                    this.splits.addElement(new Time(0, false));
                    ++this.splitNum;
                    ++n4;
                }
                this.splits.addElement(this.parseSplit(this.stringAt(this.tokens, n5)));
                ++this.splitNum;
                ++n4;
            }
            ++n5;
        }
        while (n4 < n3 && this.splitNum <= this.numControls) {
            this.splits.addElement(new Time(0, false));
            ++this.splitNum;
            ++n4;
        }
    }

    protected void formatError(String string) throws IOException {
        throw new IOException(String.valueOf(Messages.getString("SIEventLoader.Error_reading_SportIdent_HTML_file_around_line___155")) + new Integer(this.line).toString() + Messages.getString("SIEventLoader._n_in__156") + string + Messages.getString("SIEventLoader._n_Data___157") + this.st + Messages.getString("SIEventLoader._n_n_Error___158"));
    }

    protected String getLine(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            string = bufferedReader.readLine();
            ++this.line;
            if (string != null) continue;
            return string;
        } while ((string = this.StripHTMLTags(string, bufferedReader)).trim().length() == 0);
        return string;
    }

    protected String StripHTMLTags(String string, BufferedReader bufferedReader) throws IOException {
        int n;
        while ((n = string.indexOf("<")) != -1) {
            try {
                int n2;
                while ((n2 = string.indexOf(">", n)) == -1) {
                    string = string.concat(" ".concat(bufferedReader.readLine()));
                    ++this.line;
                }
                String string2 = n > 0 ? string.substring(0, n) : "";
                String string3 = n2 < string.length() ? string.substring(n2 + 1, string.length()) : "";
                string = string2.concat(string3);
            }
            catch (Exception exception) {
                throw new IOException(Messages.getString("SIEventLoader.Error_removing_HTML_tags_164"));
            }
        }
        return string;
    }

    protected int lineType(Vector vector) {
        int n = vector.size() - 1;
        int n2 = this.typeAt(vector, 0);
        int n3 = this.typeAt(vector, n);
        if (n3 == 6 || n3 == 4) {
            return 1;
        }
        if (n >= 1 && this.typeAt(vector, n - 1) == 8 || n == 0 && n3 == 9) {
            return 2;
        }
        if (this.isDisqualified(vector)) {
            return 5;
        }
        if (n >= 2 && n2 == 2 && n3 == 3) {
            return 3;
        }
        if (n >= 0 && n2 == 10) {
            return 4;
        }
        if (n >= 0 && n2 == 0) {
            return 6;
        }
        if (n2 == 3) {
            return 7;
        }
        return 0;
    }

    protected boolean isDisqualified(Vector vector) {
        int n;
        int n2 = vector.size();
        if (n2 == 0) {
            return false;
        }
        do {
            n = this.typeAt(vector, --n2);
        } while (n2 > 0 && n == 3);
        return n == 11;
    }

    protected boolean isDisqualifiedOLd(int[] nArray) {
        int n = nArray.length;
        if (nArray.length == 0) {
            return false;
        }
        while (--n > 0 && nArray[n] == 3) {
        }
        return nArray[n] == 11;
    }

    protected int tokenType(String string) {
        try {
            if (KM_SYMBOLS.indexOf(string) != -1) {
                return 4;
            }
            if (string.length() == 2 && CLIMB_SYMBOLS.indexOf(string) != -1) {
                return 5;
            }
            if (NUM_CONTROLS_SYMBOLS.indexOf(string) != -1) {
                return 6;
            }
            if (string.indexOf("(") != -1) {
                if ("0123456789".indexOf(string.substring(0, 1)) != -1) {
                    return 8;
                }
                if ("0123456789".indexOf(string.substring(1, 1)) != -1) {
                    return 7;
                }
            }
            if (string.length() == 1 && FINISH_SYMBOLS.indexOf(string) != -1) {
                return 9;
            }
            if (NON_COMP_SYMBOLS.indexOf(string) != -1) {
                return 10;
            }
            if (string.length() >= 1 && DSQ_SYMBOLS.indexOf(string) != -1) {
                return 11;
            }
            if (string.indexOf(":") != -1 && "0123456789".indexOf(string.substring(0, 1)) != -1 || string.indexOf("---") != -1 || string.indexOf("--:--") != -1 || string.charAt(0) == '*' || string.equals("0.00")) {
                return 3;
            }
            if (string.indexOf(".") != -1) {
                Float f = new Float(string);
                if (f.floatValue() > 0.0f) {
                    return 1;
                }
            }
            if (Integer.parseInt(string) > 0) {
                return 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return 0;
    }

    protected Time parseSplit(String string) throws Exception {
        if (string.indexOf("-----") != -1 || string.indexOf("--:--") != -1 || string.indexOf("*") != -1 || string.trim() == "0.00") {
            return new Time(0, false);
        }
        try {
            int n = string.indexOf(":");
            int n2 = string.lastIndexOf(":");
            if (n == n2) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                return new Time(Integer.parseInt(string2), Integer.parseInt(string3));
            }
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1, n2 - n);
            String string6 = string.substring(n2 + 1);
            int n3 = Integer.parseInt(string4);
            int n4 = Integer.parseInt(string5);
            return new Time(n4 += 60 * n3, Integer.parseInt(string6));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception(Messages.getString("SIEventLoader.Bad_split_format___180").concat(string));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static String translateChars(String var0) {
        var1_1 = var0;
        try {
            while ((var2_2 = var1_1.indexOf("&#")) != -1) {
                var5_5 = var2_2 != 0 ? var1_1.substring(0, var2_2) : "";
                var3_3 = var1_1.indexOf(";", var2_2);
                if (var3_3 == -1 || var3_3 > var2_2 + 8) {
                    var3_3 = var1_1.indexOf(" ", var2_2);
                }
                var7_7 = var1_1.substring(var2_2 + 2, var3_3);
                var6_6 = var1_1.substring(var3_3 + 1, var1_1.length());
                var4_4 = var7_7.indexOf("x") != -1 ? Integer.decode("0".concat(var7_7)).intValue() : Integer.decode(var7_7).intValue();
                var8_8 = new Character((char)var4_4);
                var1_1 = var5_5.concat(var8_8.toString()).concat(var6_6);
            }
        }
        catch (Exception v0) {}
        var9_9 = 0;
        ** GOTO lbl24
        {
            var5_5 = var2_2 != 0 ? var1_1.substring(0, var2_2) : "";
            var6_6 = var1_1.substring(var2_2 + SIEventLoader.specialChars[var9_9].length(), var1_1.length());
            var1_1 = var5_5.concat(new Character(SIEventLoader.translatedChar[var9_9]).toString()).concat(var6_6);
            do {
                if ((var2_2 = var1_1.indexOf(SIEventLoader.specialChars[var9_9])) != -1) continue block3;
                ++var9_9;
lbl24:
                // 2 sources

            } while (var9_9 < SIEventLoader.specialChars.length);
        }
        return var1_1;
    }

    protected Token sub(String string, int n) {
        int n2 = n;
        while (n2 < string.length() && string.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 == string.length()) {
            return new Token("", n2, 0);
        }
        int n3 = n2;
        while (n3 < string.length() && string.charAt(n3) != ' ') {
            ++n3;
        }
        n = n3;
        String string2 = string.substring(n2, n3);
        return new Token(string2, n3, this.tokenType(string2));
    }

    protected Vector splitTokens(String string) {
        Vector<Token> vector = new Vector<Token>(0, 1);
        int n = 0;
        boolean bl = true;
        while (n < string.length() && bl) {
            Token token = this.sub(string, n);
            if (token.value != "") {
                vector.addElement(token);
                n = token.end;
                continue;
            }
            bl = false;
        }
        return vector;
    }

    protected String stringAt(Vector vector, int n) {
        Token token = (Token)vector.elementAt(n);
        return token.value;
    }

    protected int typeAt(Vector vector, int n) {
        Token token = (Token)vector.elementAt(n);
        return token.type;
    }

    protected int colAt(Vector vector, int n) {
        Token token = (Token)vector.elementAt(n);
        return token.end;
    }
}

