/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class Result
implements Serializable {
    private String firstName;
    private String surname;
    private String fullName;
    private String club;
    private Course course;
    private Time startTime = null;
    private Time[] splitTimes = null;
    private int[] positions = null;
    private transient Time[] elaspedTimes = null;
    private transient Time[] timeLoss = null;

    public Result() {
    }

    private Result(Course course, Time time, Time[] timeArray) {
        this.course = course;
        this.splitTimes = timeArray;
        this.startTime = time;
        this.elaspedTimes = null;
        this.positions = new int[this.course.getNumSplits()];
        this.course.addResult(this);
    }

    public Result(String string, String string2, String string3, Course course, Time time, Time[] timeArray) {
        this(course, time, timeArray);
        this.setFirstName(string);
        this.setSurname(string2);
        this.setClub(string3);
    }

    public void setFirstName(String string) {
        this.firstName = string;
        this.fullName = String.valueOf(this.firstName) + " " + this.surname;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setSurname(String string) {
        this.surname = string;
        this.fullName = String.valueOf(this.firstName) + " " + this.surname;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setClub(String string) {
        this.club = string;
    }

    public String getClub() {
        return this.club;
    }

    public Time getTotalTime() {
        return this.getElaspsed(this.course.getNumSplits() - 1);
    }

    public Time getSplit(int n) {
        return this.splitTimes[n];
    }

    public Time getElaspsed(int n) {
        if (this.elaspedTimes == null) {
            this.elaspedTimes = new Time[this.course.getNumSplits()];
            int n2 = 0;
            int n3 = this.course.getNumSplits();
            int n4 = 0;
            while (n4 < n3) {
                this.elaspedTimes[n4] = new Time(n2 += this.splitTimes[n4].asSeconds(), this.splitTimes[n4].isValid());
                ++n4;
            }
        }
        return this.elaspedTimes[n];
    }

    protected void computeTimeLosses() {
        int n;
        int n2 = this.course.getNumControls() < 10 ? 2 : (this.course.getNumControls() < 15 ? 3 : 4);
        double[] dArray = new double[]{-1000.0, -1000.0, -1000.0, -1000.0};
        int[] nArray = new int[]{-1, -1, -1, -1};
        int n3 = 0;
        while (n3 < this.course.getNumSplits()) {
            n = 0;
            while (n < n2) {
                double d = this.getSplit(n).asSeconds() / this.course.getOptimumTime(n3).asSeconds();
                if (d > dArray[n]) {
                    dArray[n] = d;
                    nArray[n] = n;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        n3 = this.getTotalTime().asSeconds();
        n = this.course.getOptimumTime(this.course.getNumSplits()).asSeconds();
        int n4 = 0;
        while (n4 < n2) {
            n3 -= this.getSplit(nArray[n4]).asSeconds();
            n -= this.course.getOptimumTime(nArray[n4]).asSeconds();
            ++n4;
        }
        double d = n3 / n;
        int n5 = 0;
        while (n5 < this.course.getNumSplits()) {
            int n6 = new Double((double)this.getSplit(n5).asSeconds() * d).intValue();
            this.timeLoss[n5] = new Time(n6 - this.course.getOptimumTime(n5).asSeconds());
            ++n5;
        }
    }

    public Time getTimeLoss(int n) {
        if (this.timeLoss == null) {
            this.timeLoss = new Time[this.course.getNumSplits()];
            this.computeTimeLosses();
        }
        return this.timeLoss[n];
    }

    public Time getTimeBehindOptimum(int n) {
        Time time = new Time(this.getSplit(n).asSeconds() - this.course.getOptimumTime(n).asSeconds());
        return time;
    }

    public Time getActualTime(int n) {
        int n2 = this.startTime.asSeconds() + this.getElaspsed(n).asSeconds();
        return new Time(n2);
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public int getPosition() {
        return this.course.getPosition(this);
    }

    public int getSplitPosition(int n) {
        return this.positions[n];
    }

    void setPosition(int n, int n2) {
        this.positions[n] = n2;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getNameAndTime() {
        return String.valueOf(this.fullName) + "  " + this.getTotalTime().toString();
    }
}

