/*
 * Decompiled with CFR 0.152.
 */
public class OptimumTimeAlgorithms {
    public static Winner winner = new Winner();
    public static Fastest fastest = new Fastest();
    public static Comparison comparison = new Comparison();
    public static PercentBehind percentBehind = new PercentBehind();

    public interface IOptimumTimeAlgorithm {
        public static final int DEFAULT_TIME = 60;

        public Time computeTime(Course var1, int var2);

        public String getName();
    }

    public static class Winner
    implements IOptimumTimeAlgorithm {
        private String name = "Winners time";

        public String getName() {
            return this.name;
        }

        public Time computeTime(Course course, int n) {
            return course.getWinner().getSplit(n);
        }
    }

    public static class Fastest
    implements IOptimumTimeAlgorithm {
        private String name = "Fastest split time";

        public String getName() {
            return this.name;
        }

        public Time computeTime(Course course, int n) {
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            while (n3 < course.getNumResults()) {
                Time time = course.getResult(n3).getSplit(n);
                if (time.isValid() && time.asSeconds() != 0) {
                    n2 = Math.min(n2, time.asSeconds());
                }
                ++n3;
            }
            if (n2 == Integer.MAX_VALUE) {
                n2 = 60;
            }
            return new Time(n2);
        }
    }

    public static class Comparison
    implements IOptimumTimeAlgorithm {
        private String name = "Compare with competitor";
        private Result competitor;

        public void setCompetitor(Result result) {
            this.competitor = result;
        }

        public String getName() {
            return this.name;
        }

        public Time computeTime(Course course, int n) {
            return this.competitor.getSplit(n);
        }
    }

    public static class PercentBehind
    extends Fastest
    implements IOptimumTimeAlgorithm {
        private String name = "Percent behind the best time";
        private int totalPercent = 0;

        public void setPercentBehind(int n) {
            this.totalPercent = 100 + n;
        }

        public String getName() {
            return this.name;
        }

        public Time computeTime(Course course, int n) {
            Time time = super.computeTime(course, n);
            int n2 = time.asSeconds() * this.totalPercent / 100;
            return new Time(n2);
        }
    }
}

