/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Vector;

public class Course
implements Serializable {
    private boolean sortOnSplits;
    private int sortSplit;
    private double distance;
    private double climb;
    private int numControls;
    private OEvent event;
    private String ageClass;
    private Vector results = new Vector();
    private OptimumTimeAlgorithms.IOptimumTimeAlgorithm optimumTimeAlgorithm = null;
    private transient boolean optimumTimesInvalid = true;
    private transient Time[] optimumTimes = null;
    private transient Time[] cumulativeOptimumTimes = null;
    private transient Result winner = null;

    public Course(OEvent oEvent) {
        this.event = oEvent;
        this.ageClass = "";
        this.numControls = 0;
    }

    public Course(OEvent oEvent, String string, int n) throws Exception {
        if (string == "") {
            throw new Exception(Messages.getString("Course.No_class_name_specified"));
        }
        if (n == 0) {
            throw new Exception(Messages.getString("Course.No_controls_specified"));
        }
        this.event = oEvent;
        this.event.addCourse(this);
        this.ageClass = string;
        this.numControls = n;
        this.optimumTimes = new Time[this.getNumSplits()];
        this.cumulativeOptimumTimes = new Time[this.getNumSplits()];
    }

    public Course(OEvent oEvent, String string, int n, double d, double d2) throws Exception {
        this(oEvent, string, n);
        this.distance = d;
        this.climb = d2;
    }

    public String getName() {
        return this.ageClass;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getClimb() {
        return this.climb;
    }

    public int getNumControls() {
        return this.numControls;
    }

    public Result getResult(int n) {
        return (Result)this.results.elementAt(n);
    }

    public int getNumSplits() {
        return this.numControls + 1;
    }

    public void addResult(Result result) {
        boolean bl;
        this.optimumTimesInvalid = true;
        this.winner = null;
        int n = this.getNumResults();
        int n2 = result.getTotalTime().asSeconds();
        if (n == 0) {
            this.results.addElement(result);
            return;
        }
        Result result2 = this.getResult(n - 1);
        boolean bl2 = bl = n2 >= result2.getTotalTime().asSeconds();
        if (bl) {
            this.results.addElement(result);
            return;
        }
        int n3 = 0;
        int n4 = this.getResult(n3).getTotalTime().asSeconds();
        while (n2 > n4) {
            n4 = this.getResult(++n3).getTotalTime().asSeconds();
        }
        this.results.insertElementAt(result, n3);
    }

    int getPosition(Result result) {
        return this.results.indexOf(result);
    }

    public int getNumResults() {
        return this.results.size();
    }

    public void setOptimumTimeAlgorithm(OptimumTimeAlgorithms.IOptimumTimeAlgorithm iOptimumTimeAlgorithm) {
        this.optimumTimeAlgorithm = iOptimumTimeAlgorithm;
        this.optimumTimesInvalid = true;
    }

    public OptimumTimeAlgorithms.IOptimumTimeAlgorithm getOptimumTimeAlgorithm() {
        return this.optimumTimeAlgorithm;
    }

    public Time getOptimumTime(int n) {
        if (this.optimumTimesInvalid) {
            this.computeOptimumTimes();
        }
        return this.optimumTimes[n];
    }

    public Time getCumulativeOptimumTime(int n) {
        if (this.optimumTimesInvalid) {
            this.computeOptimumTimes();
        }
        return this.cumulativeOptimumTimes[n];
    }

    protected void computeOptimumTimes() {
        if (this.optimumTimeAlgorithm != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.getNumSplits()) {
                this.optimumTimes[n2] = this.optimumTimeAlgorithm.computeTime(this, n2);
                this.cumulativeOptimumTimes[n2] = new Time(n += this.optimumTimes[n2].asSeconds());
                ++n2;
            }
        } else {
            int n = 0;
            while (n < this.getNumSplits()) {
                this.optimumTimes[n] = Time.ZERO_TIME;
                this.cumulativeOptimumTimes[n] = Time.ZERO_TIME;
                ++n;
            }
        }
        this.optimumTimesInvalid = false;
    }

    public Result getWinner() {
        if (this.winner == null) {
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            while (n2 < this.getNumResults()) {
                int n3 = this.getResult(n2).getTotalTime().asSeconds();
                if (n3 < n) {
                    n = n3;
                    this.winner = this.getResult(n2);
                }
                ++n2;
            }
        }
        return this.winner;
    }

    protected void computeSplitPositions(int n) throws Exception {
        Object[] objectArray = new Result[this.results.size()];
        this.results.copyInto(objectArray);
        this.sortSplit = n;
        this.sortOnSplits = true;
        this.QuickSort((Result[])objectArray, 0, objectArray.length - 1, n);
        this.InsertionSort((Result[])objectArray, 0, objectArray.length - 1, n);
        int n2 = 0;
        while (n2 < this.results.size()) {
            ((Result)objectArray[n2]).setPosition(n, n2);
            ++n2;
        }
    }

    private void QuickSort(Result[] resultArray, int n, int n2, int n3) throws Exception {
        int n4 = 4;
        if (n2 - n > n4) {
            int n5 = (n2 + n) / 2;
            if (resultArray[n].getSplit(n3).asSeconds() > resultArray[n5].getSplit(n3).asSeconds()) {
                this.swap(resultArray, n, n5);
            }
            if (resultArray[n].getSplit(n3).asSeconds() > resultArray[n2].getSplit(n3).asSeconds()) {
                this.swap(resultArray, n, n2);
            }
            if (resultArray[n5].getSplit(n3).asSeconds() > resultArray[n2].getSplit(n3).asSeconds()) {
                this.swap(resultArray, n5, n2);
            }
            int n6 = n2 - 1;
            this.swap(resultArray, n5, n6);
            n5 = n;
            Result result = resultArray[n6];
            while (true) {
                if (resultArray[++n5].getSplit(n3).asSeconds() < result.getSplit(n3).asSeconds()) {
                    continue;
                }
                while (resultArray[--n6].getSplit(n3).asSeconds() > result.getSplit(n3).asSeconds()) {
                }
                if (n6 < n5) break;
                this.swap(resultArray, n5, n6);
            }
            this.swap(resultArray, n5, n2 - 1);
            this.QuickSort(resultArray, n, n6, n3);
            this.QuickSort(resultArray, n5 + 1, n2, n3);
        }
    }

    private void InsertionSort(Result[] resultArray, int n, int n2, int n3) throws Exception {
        int n4 = n + 1;
        while (n4 <= n2) {
            Result result = resultArray[n4];
            int n5 = n4;
            while (n5 > n && resultArray[n5 - 1].getSplit(n3).asSeconds() > result.getSplit(n3).asSeconds()) {
                resultArray[n5] = resultArray[n5 - 1];
                --n5;
            }
            resultArray[n5] = result;
            ++n4;
        }
    }

    private void swap(Result[] resultArray, int n, int n2) {
        Result result = resultArray[n];
        resultArray[n] = resultArray[n2];
        resultArray[n2] = result;
    }
}

