/*
 * Decompiled with CFR 0.152.
 */
public class Axis {
    private double maxPixel = 0.0;
    private double minPixel = 0.0;
    private double maxTime = Time.ZERO_TIME.asSeconds();
    private double minTime = Time.ZERO_TIME.asSeconds();
    private transient int firstLabel;
    private transient int gridInterval;
    private transient double pixelsPerSec;
    private static int SEC_PER_MIN = 60;
    private boolean roundTimes;
    private static final int[] intervals = new int[]{1, 2, 5};
    private static final int noIntervals = 3;

    public Axis(boolean bl) {
        this.roundTimes = bl;
    }

    public int getMaxPixel() {
        return (int)this.maxPixel;
    }

    public void setMaxPixel(int n) {
        this.maxPixel = n;
        this.computeMapping();
    }

    public int getMinPixel() {
        return (int)this.minPixel;
    }

    public void setMinPixel(int n) {
        this.minPixel = n;
        this.computeMapping();
    }

    public Time getMaxTime() {
        return new Time((int)this.maxTime);
    }

    public void setMaxTime(Time time) {
        this.maxTime = this.roundTimes ? (double)(SEC_PER_MIN * (time.asSeconds() / SEC_PER_MIN + 1)) : (double)time.asSeconds();
        this.computeMapping();
    }

    public Time getMinTime() {
        return new Time((int)this.minTime);
    }

    public void setMinTime(Time time) {
        if (this.roundTimes) {
            this.minTime = SEC_PER_MIN * (time.asSeconds() / SEC_PER_MIN);
            if (time.asSeconds() < 0) {
                this.minTime -= (double)SEC_PER_MIN;
            }
        } else {
            this.minTime = time.asSeconds();
        }
        this.computeMapping();
    }

    public int getNumLabels() {
        return ((int)this.maxTime - this.firstLabel) / this.gridInterval + 1;
    }

    public int getLabelPixel(int n) {
        return this.toPixel(this.firstLabel + n * this.gridInterval);
    }

    public String getLabelString(int n) {
        return new Integer((this.firstLabel + n * this.gridInterval) / SEC_PER_MIN).toString();
    }

    public void setRoundTimes(boolean bl) {
        this.roundTimes = bl;
        this.computeMapping();
    }

    public boolean getRoundTimes() {
        return this.roundTimes;
    }

    public Time toTime(int n) {
        int n2 = (int)((double)n / this.pixelsPerSec + this.minTime);
        return new Time(n2);
    }

    public int toPixel(Time time) {
        return (int)(((double)time.asSeconds() - this.minTime) * this.pixelsPerSec + this.minPixel);
    }

    public int toPixel(int n) {
        return (int)(((double)n - this.minTime) * this.pixelsPerSec + this.minPixel);
    }

    private void computeMapping() {
        if (this.maxTime < (double)SEC_PER_MIN) {
            this.maxTime = SEC_PER_MIN;
        }
        double d = this.maxTime - this.minTime;
        this.pixelsPerSec = (this.maxPixel - this.minPixel) / d;
        this.gridInterval = this.gridInt(d);
        int n = (int)this.minTime / this.gridInterval;
        this.firstLabel = n * this.gridInterval;
    }

    private int gridInt(double d) {
        int n = (int)(d / (double)SEC_PER_MIN) / 6;
        int n2 = 1;
        int n3 = 0;
        while (true) {
            n3 = 0;
            while (n3 < 3) {
                int n4 = intervals[n3] * n2;
                if (n4 >= n) {
                    return n4 * SEC_PER_MIN;
                }
                ++n3;
            }
            n2 *= 10;
        }
    }
}

